/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.tracker;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.karaf.util.tracker.SingleServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseActivator
implements BundleActivator,
SingleServiceTracker.SingleServiceListener,
Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BundleContext bundleContext;
    protected ExecutorService executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private AtomicBoolean scheduled = new AtomicBoolean();
    private long schedulerStopTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private final Queue<ServiceRegistration> registrations = new ConcurrentLinkedQueue<ServiceRegistration>();
    private Map<String, SingleServiceTracker> trackers = new HashMap<String, SingleServiceTracker>();
    private ServiceRegistration managedServiceRegistration;
    private Dictionary<String, ?> configuration;

    public long getSchedulerStopTimeout() {
        return this.schedulerStopTimeout;
    }

    public void setSchedulerStopTimeout(long schedulerStopTimeout) {
        this.schedulerStopTimeout = schedulerStopTimeout;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.scheduled.set(true);
        this.doOpen();
        this.scheduled.set(false);
        boolean doStart = false;
        if (this.managedServiceRegistration == null) {
            doStart = true;
            for (SingleServiceTracker s : this.trackers.values()) {
                if (s.getService() != null) continue;
                doStart = false;
                break;
            }
        }
        if (doStart) {
            try {
                this.doStart();
            }
            catch (Exception e) {
                this.logger.warn("Error starting activator", (Throwable)e);
                this.doStop();
            }
        } else {
            this.reconfigure();
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.scheduled.set(true);
        this.doClose();
        this.executor.shutdown();
        this.executor.awaitTermination(this.schedulerStopTimeout, TimeUnit.MILLISECONDS);
        this.doStop();
    }

    protected void doOpen() throws Exception {
        URL data = this.bundleContext.getBundle().getResource("OSGI-INF/karaf-tracker/" + this.getClass().getName());
        if (data != null) {
            Properties props = new Properties();
            try (InputStream is = data.openStream();){
                props.load(is);
            }
            for (String key : props.stringPropertyNames()) {
                if ("pid".equals(key)) {
                    this.manage(props.getProperty(key));
                    continue;
                }
                this.trackService(key, props.getProperty(key));
            }
        }
    }

    protected void doClose() {
        if (this.managedServiceRegistration != null) {
            this.managedServiceRegistration.unregister();
        }
        for (SingleServiceTracker tracker : this.trackers.values()) {
            tracker.close();
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() {
        ServiceRegistration reg;
        while ((reg = this.registrations.poll()) != null) {
            reg.unregister();
        }
    }

    protected void manage(String pid) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", pid);
        this.managedServiceRegistration = this.bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)this, props);
    }

    public void updated(Dictionary<String, ?> properties) {
        this.configuration = properties;
        this.reconfigure();
    }

    protected Dictionary<String, ?> getConfiguration() {
        return this.configuration;
    }

    protected int getInt(String key, int def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val != null) {
                return Integer.parseInt(val.toString());
            }
        }
        return def;
    }

    protected boolean getBoolean(String key, boolean def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            if (val != null) {
                return Boolean.parseBoolean(val.toString());
            }
        }
        return def;
    }

    protected long getLong(String key, long def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).longValue();
            }
            if (val != null) {
                return Long.parseLong(val.toString());
            }
        }
        return def;
    }

    protected String getString(String key, String def) {
        Object val;
        if (this.configuration != null && (val = this.configuration.get(key)) != null) {
            return val.toString();
        }
        return def;
    }

    @Override
    public void serviceFound() {
        this.reconfigure();
    }

    @Override
    public void serviceLost() {
        this.reconfigure();
    }

    @Override
    public void serviceReplaced() {
        this.reconfigure();
    }

    protected void reconfigure() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.executor.submit(this);
        }
    }

    @Override
    public void run() {
        this.scheduled.set(false);
        this.doStop();
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.logger.warn("Error starting activator", (Throwable)e);
            this.doStop();
        }
    }

    protected void trackService(Class<?> clazz) throws InvalidSyntaxException {
        if (!this.trackers.containsKey(clazz.getName())) {
            SingleServiceTracker tracker = new SingleServiceTracker(this.bundleContext, clazz, this);
            tracker.open();
            this.trackers.put(clazz.getName(), tracker);
        }
    }

    protected void trackService(Class<?> clazz, String filter) throws InvalidSyntaxException {
        if (!this.trackers.containsKey(clazz.getName())) {
            if (filter != null && filter.isEmpty()) {
                filter = null;
            }
            SingleServiceTracker tracker = new SingleServiceTracker(this.bundleContext, clazz, filter, (SingleServiceTracker.SingleServiceListener)this);
            tracker.open();
            this.trackers.put(clazz.getName(), tracker);
        }
    }

    protected void trackService(String className, String filter) throws InvalidSyntaxException {
        if (!this.trackers.containsKey(className)) {
            SingleServiceTracker tracker = new SingleServiceTracker(this.bundleContext, className, filter, (SingleServiceTracker.SingleServiceListener)this);
            tracker.open();
            this.trackers.put(className, tracker);
        }
    }

    protected <T> T getTrackedService(Class<T> clazz) {
        SingleServiceTracker tracker = this.trackers.get(clazz.getName());
        if (tracker == null) {
            throw new IllegalStateException("Service not tracked for class " + clazz);
        }
        return clazz.cast(tracker.getService());
    }

    protected void registerMBean(Object mbean, String type) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("jmx.objectname", "org.apache.karaf:" + type + ",name=" + System.getProperty("karaf.name"));
        this.trackRegistration(this.bundleContext.registerService(this.getInterfaceNames(mbean), mbean, props));
    }

    protected <T> void register(Class<T> clazz, T service) {
        this.register(clazz, service, null);
    }

    protected <T> void register(Class<T> clazz, T service, Dictionary<String, ?> props) {
        this.trackRegistration(this.bundleContext.registerService(clazz, service, props));
    }

    protected void register(Class[] clazz, Object service) {
        this.register(clazz, service, null);
    }

    protected void register(Class[] clazz, Object service, Dictionary<String, ?> props) {
        String[] names = new String[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            names[i] = clazz[i].getName();
        }
        this.trackRegistration(this.bundleContext.registerService(names, service, props));
    }

    private void trackRegistration(ServiceRegistration registration) {
        this.registrations.add(registration);
    }

    protected String[] getInterfaceNames(Object object) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> cl = object.getClass(); cl != Object.class; cl = cl.getSuperclass()) {
            this.addSuperInterfaces(names, cl);
        }
        return names.toArray(new String[names.size()]);
    }

    private void addSuperInterfaces(List<String> names, Class clazz) {
        for (Class<?> cl : clazz.getInterfaces()) {
            names.add(cl.getName());
            this.addSuperInterfaces(names, cl);
        }
    }
}

