/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandlerResult;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;

public class CorrelateAllMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<List<MessageCorrelationResult>> {
    public CorrelateAllMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        super(messageCorrelationBuilderImpl);
    }

    @Override
    public List<MessageCorrelationResult> execute(final CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.builder.getBusinessKey(), this.builder.getCorrelationProcessInstanceVariables(), this.builder.getProcessInstanceId());
        final CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        final CorrelationSet correlationSet = new CorrelationSet(this.builder);
        List<CorrelationHandlerResult> correlationResults = commandContext.runWithoutAuthorization(new Callable<List<CorrelationHandlerResult>>(){

            @Override
            public List<CorrelationHandlerResult> call() throws Exception {
                return correlationHandler.correlateMessages(commandContext, CorrelateAllMessageCmd.this.messageName, correlationSet);
            }
        });
        for (CorrelationHandlerResult correlationResult : correlationResults) {
            this.checkAuthorization(correlationResult);
        }
        ArrayList<MessageCorrelationResult> results = new ArrayList<MessageCorrelationResult>();
        for (CorrelationHandlerResult correlationResult : correlationResults) {
            results.add(this.createMessageCorrelationResult(commandContext, correlationResult));
        }
        return results;
    }
}

