/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.extension.osgi.internal.ProcessDefinitionDeployer;

public class ProcessDefinitionDeployerImpl
implements ProcessDefinitionDeployer {
    private static final Logger LOGGER = Logger.getLogger(ProcessDefinitionDeployerImpl.class.getName());
    private volatile ProcessEngine engine;

    public ProcessDefinitionDeployerImpl() {
    }

    public ProcessDefinitionDeployerImpl(ProcessEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployProcessDefinitions(String bundleSymbolicName, List<URL> pathList) {
        try {
            LOGGER.log(Level.FINE, "Found process in bundle " + bundleSymbolicName + " with paths: " + pathList);
            if (this.engine == null) {
                throw new IllegalStateException("Unable to find a ProcessEngine service");
            }
            RepositoryService service = this.engine.getRepositoryService();
            DeploymentBuilder builder = service.createDeployment();
            builder.name(bundleSymbolicName);
            for (URL url : pathList) {
                InputStream is = url.openStream();
                if (is == null) {
                    throw new IOException("Error opening url: " + url);
                }
                try {
                    builder.addInputStream(this.getPath(url), is);
                }
                finally {
                    is.close();
                }
            }
            builder.enableDuplicateFiltering(true);
            builder.deploy();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to deploy bundle", e);
        }
    }

    private String getPath(URL url) {
        String path = url.toExternalForm();
        return path.replaceAll("bundle://[^/]*/", "");
    }
}

