/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinition;

@Command(scope="camunda", name="export-diagram", description="Export definition of a diagram")
public class ExportDiagram
extends OsgiCommandSupport {
    private final ProcessEngine engine;
    @Argument(index=0, name="processDefinitionId", description="Process definition id", required=true, multiValued=false)
    private String processDefinitionId;

    public ExportDiagram(ProcessEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        InputStream is = this.engine.getRepositoryService().getProcessDiagram(this.processDefinitionId);
        ProcessDefinition def = this.engine.getRepositoryService().getProcessDefinition(this.processDefinitionId);
        File exportFIle = File.createTempFile("camunda", def.getName());
        FileOutputStream fis = null;
        try {
            int len;
            fis = new FileOutputStream(exportFIle);
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) > -1) {
                fis.write(buffer, 0, len);
            }
            fis.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        System.out.println("Process graph exported to " + exportFIle.getAbsolutePath());
        return null;
    }
}

