/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.osgi.commands.asciitable.ASCIITable;

@Command(scope="camunda", name="instance-list", description="List process instances of a specific process definition.")
public class InstanceList
extends OsgiCommandSupport {
    private final ProcessEngine engine;
    @Argument(index=0, name="process definition id", description="Id of the process definition. If all process definition will be printed from the latest deployment.", multiValued=false)
    private String processDefinitionId;
    private static final String[] HEADER = new String[]{"ID", "DURATION", "BUSINESS_KEY", "START_USER_ID"};

    public InstanceList(ProcessEngine engine) {
        this.engine = engine;
    }

    protected Object doExecute() throws Exception {
        if (this.processDefinitionId != null) {
            this.printProcessInfo(this.processDefinitionId);
        } else {
            List deployments = ((DeploymentQuery)this.engine.getRepositoryService().createDeploymentQuery().orderByDeploymenTime().desc()).listPage(0, 1);
            Deployment lastDeployment = (Deployment)deployments.get(0);
            System.out.println("Process instance for the last deployment: " + lastDeployment.getId());
            for (ProcessDefinition process : this.engine.getRepositoryService().createProcessDefinitionQuery().deploymentId(lastDeployment.getId()).list()) {
                System.out.println("\nInstances for the process definition: " + process.getId());
                this.printProcessInfo(process.getId());
            }
        }
        return null;
    }

    public void printProcessInfo(String id) {
        List executions = this.engine.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionId(id).list();
        String[][] data = new String[executions.size()][HEADER.length];
        int i = 0;
        for (HistoricProcessInstance instance : executions) {
            data[i++] = new String[]{instance.getId(), instance.getDurationInMillis() + " ms", instance.getBusinessKey(), instance.getStartUserId()};
        }
        ASCIITable.getInstance().printTable(HEADER, data);
    }
}

