/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;

@Command(scope="camunda", name="task-list", description="List tasks for a specific process definition.")
public class TaskList
extends OsgiCommandSupport {
    private static final String[] HEADER = new String[]{"ID", "INSTANCE", "PROCESS_DEF", "ASIGNEE", "NAME"};
    private final ProcessEngine engine;
    @Argument(index=0, name="process definition id", description="Process definition id", multiValued=false)
    private String processId;

    public TaskList(ProcessEngine engine) {
        this.engine = engine;
    }

    protected Object doExecute() throws Exception {
        TaskQuery taskQuery = this.engine.getTaskService().createTaskQuery();
        if (this.processId != null) {
            taskQuery.processDefinitionId(this.processId);
        }
        List tasks = ((TaskQuery)taskQuery.orderByTaskCreateTime().asc()).list();
        int i = 0;
        String[][] data = new String[tasks.size()][HEADER.length];
        for (Task task : tasks) {
            data[i++] = new String[]{task.getId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getAssignee(), task.getName()};
        }
        return null;
    }
}

