/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.configadmin.impl;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.extension.osgi.classloading.BundleDelegatingClassLoader;
import org.camunda.bpm.extension.osgi.classloading.ClassLoaderWrapper;
import org.camunda.bpm.extension.osgi.configadmin.ManagedProcessEngineFactory;
import org.camunda.bpm.extension.osgi.configadmin.impl.ProcessEngineConfigurationFromProperties;
import org.camunda.bpm.extension.osgi.engine.ProcessEngineFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;

public class ManagedProcessEngineFactoryImpl
implements ManagedProcessEngineFactory {
    private Map<String, ProcessEngine> existingEngines = new ConcurrentHashMap<String, ProcessEngine>();
    private Map<String, ServiceRegistration<ProcessEngine>> existingRegisteredEngines = new ConcurrentHashMap<String, ServiceRegistration<ProcessEngine>>();
    private volatile Bundle bundle;

    public ManagedProcessEngineFactoryImpl() {
    }

    public ManagedProcessEngineFactoryImpl(Bundle bundle) {
        this.bundle = bundle;
    }

    public String getName() {
        return "org.camunda.bpm.extension.osgi.configadmin.ManagedProcessEngineFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ProcessEngine engine;
        if (this.existingEngines.containsKey(pid)) {
            this.existingEngines.get(pid).close();
            this.existingEngines.remove(pid);
            this.existingRegisteredEngines.get(pid).unregister();
            this.existingRegisteredEngines.remove(pid);
        }
        if (!this.hasPropertiesConfiguration(properties)) {
            return;
        }
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        try {
            BundleDelegatingClassLoader cl = new BundleDelegatingClassLoader(this.bundle);
            Thread.currentThread().setContextClassLoader((ClassLoader)new ClassLoaderWrapper(new ClassLoader[]{cl, ProcessEngineFactory.class.getClassLoader(), ProcessEngineConfiguration.class.getClassLoader(), previous}));
            ProcessEngineConfiguration processEngineConfiguration = this.createProcessEngineConfiguration(properties);
            processEngineConfiguration.setClassLoader((ClassLoader)cl);
            engine = processEngineConfiguration.buildProcessEngine();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
        this.existingEngines.put(pid, engine);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("process-engine-name", engine.getName());
        ServiceRegistration serviceRegistration = this.bundle.getBundleContext().registerService(ProcessEngine.class, (Object)engine, props);
        this.existingRegisteredEngines.put(pid, (ServiceRegistration<ProcessEngine>)serviceRegistration);
    }

    private boolean hasPropertiesConfiguration(Dictionary properties) {
        HashMap mapProperties = new HashMap(properties.size());
        for (Object key : Collections.list(properties.keys())) {
            mapProperties.put(key, properties.get(key));
        }
        mapProperties.remove("service.pid");
        mapProperties.remove("service.factoryPid");
        return !mapProperties.isEmpty();
    }

    private ProcessEngineConfiguration createProcessEngineConfiguration(Dictionary properties) throws ConfigurationException {
        ProcessEngineConfigurationFromProperties processEngineConfiguration = new ProcessEngineConfigurationFromProperties();
        processEngineConfiguration.configure(properties);
        return processEngineConfiguration;
    }

    public void deleted(String pid) {
        ProcessEngine engine = this.existingEngines.get(pid);
        if (engine != null) {
            engine.close();
            this.existingEngines.remove(pid);
            this.existingRegisteredEngines.get(pid).unregister();
            this.existingRegisteredEngines.remove(pid);
        }
    }
}

