/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.eventing.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.camunda.bpm.extension.osgi.eventing.api.OSGiEventBridgeActivator;
import org.camunda.bpm.extension.osgi.eventing.impl.OSGiEventDistributor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;

public class EventDistributorHandler
implements InvocationHandler {
    private final Bundle systemBundle;

    public EventDistributorHandler(BundleContext context) {
        this.systemBundle = context.getBundle(0L);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        EventAdmin eventAdmin;
        if (this.isObjectMethod(method)) {
            return this.handleObjectMethod(proxy, method, args);
        }
        if (this.isEventBridgeActivatorPresent(this.systemBundle.getBundleContext()) && (eventAdmin = this.findEventAdmin(this.systemBundle.getBundleContext())) != null) {
            OSGiEventDistributor distributor = new OSGiEventDistributor(eventAdmin);
            return method.invoke((Object)distributor, args);
        }
        return null;
    }

    private boolean isObjectMethod(Method method) {
        return Object.class.equals(method.getDeclaringClass());
    }

    private Object handleObjectMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if ("equals".equals(name)) {
            return proxy == args[0];
        }
        if ("hashCode".equals(name)) {
            return System.identityHashCode(proxy);
        }
        if ("toString".equals(name)) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy)) + ", with InvocationHandler " + this;
        }
        throw new IllegalStateException(String.valueOf(method));
    }

    private boolean isEventBridgeActivatorPresent(BundleContext ctx) {
        ServiceReference reference = ctx.getServiceReference(OSGiEventBridgeActivator.class);
        if (reference != null) {
            return ctx.getService(reference) != null;
        }
        return false;
    }

    private EventAdmin findEventAdmin(BundleContext ctx) {
        ServiceReference ref = ctx.getServiceReference(EventAdmin.class);
        EventAdmin eventAdmin = null;
        if (ref != null) {
            eventAdmin = (EventAdmin)ctx.getService(ref);
        }
        return eventAdmin;
    }
}

