/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.eventing.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;
import org.camunda.bpm.extension.osgi.eventing.api.OSGiEventBridgeActivator;
import org.camunda.bpm.extension.osgi.eventing.impl.EventDistributorHandler;
import org.osgi.framework.Bundle;

public class GlobalOSGiEventBridgeActivator
extends AbstractBpmnParseListener
implements OSGiEventBridgeActivator {
    private volatile Bundle bundle;
    private EventDistributorHandler handler;

    protected void addEndEventListener(ActivityImpl activity) {
        activity.addExecutionListener("end", this.createExecutionListener((CoreModelElement)activity));
    }

    protected void addStartEventListener(ActivityImpl activity) {
        activity.addExecutionListener("start", this.createExecutionListener((CoreModelElement)activity));
    }

    protected void addTakeEventListener(TransitionImpl transition) {
        transition.addExecutionListener(this.createExecutionListener((CoreModelElement)transition));
    }

    protected void addTaskAssignmentListeners(TaskDefinition taskDefinition) {
        taskDefinition.addTaskListener("assignment", this.createTaskListener(taskDefinition));
    }

    protected void addTaskCreateListeners(TaskDefinition taskDefinition) {
        taskDefinition.addTaskListener("create", this.createTaskListener(taskDefinition));
    }

    protected void addTaskCompleteListeners(TaskDefinition taskDefinition) {
        taskDefinition.addTaskListener("complete", this.createTaskListener(taskDefinition));
    }

    protected void addTaskDeleteListeners(TaskDefinition taskDefinition) {
        taskDefinition.addTaskListener("delete", this.createTaskListener(taskDefinition));
    }

    private TaskListener createTaskListener(TaskDefinition taskDefinition) {
        return (TaskListener)Proxy.newProxyInstance(taskDefinition.getClass().getClassLoader(), new Class[]{TaskListener.class}, (InvocationHandler)this.createEventDistributorHandler());
    }

    private ExecutionListener createExecutionListener(CoreModelElement activity) {
        return (ExecutionListener)Proxy.newProxyInstance(activity.getClass().getClassLoader(), new Class[]{ExecutionListener.class}, (InvocationHandler)this.createEventDistributorHandler());
    }

    private EventDistributorHandler createEventDistributorHandler() {
        if (this.handler == null) {
            this.handler = new EventDistributorHandler(this.bundle.getBundleContext());
        }
        return this.handler;
    }

    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
    }

    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl startEventActivity) {
        this.addStartEventListener(startEventActivity);
        this.addEndEventListener(startEventActivity);
    }

    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
        UserTaskActivityBehavior activityBehavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = activityBehavior.getTaskDefinition();
        this.addTaskCreateListeners(taskDefinition);
        this.addTaskAssignmentListeners(taskDefinition);
        this.addTaskCompleteListeners(taskDefinition);
        this.addTaskDeleteListeners(taskDefinition);
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl timerActivity) {
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
    }

    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseProperty(Element propertyElement, VariableDeclaration variableDeclaration, ActivityImpl activity) {
    }

    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
        this.addTakeEventListener(transition);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
    }

    public void parseRootElement(Element rootElement, List<ProcessDefinitionEntity> processDefinitions) {
    }

    public void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity) {
        this.addStartEventListener(timerActivity);
        this.addEndEventListener(timerActivity);
    }

    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseIntermediateSignalCatchEventDefinition(Element signalEventDefinition, ActivityImpl signalActivity) {
        this.addStartEventListener(signalActivity);
        this.addEndEventListener(signalActivity);
    }

    public void parseBoundarySignalEventDefinition(Element signalEventDefinition, boolean interrupting, ActivityImpl signalActivity) {
    }

    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl compensationActivity) {
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addStartEventListener(activity);
        this.addEndEventListener(activity);
    }

    public void parseIntermediateMessageCatchEventDefinition(Element messageEventDefinition, ActivityImpl nestedActivity) {
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl messageActivity) {
    }
}

