/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.fileinstall.impl.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameVersionTypeExtractor {
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
    private static final Pattern FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);
    private static Pattern SIMPLE_FILENAME_MATCHER = Pattern.compile("(.+)\\.(.+)", 32);

    public static String[] extractNameVersionType(String jarName) {
        Matcher m = ARTIFACT_MATCHER.matcher(jarName);
        if (!m.matches()) {
            m = SIMPLE_FILENAME_MATCHER.matcher(jarName);
            if (m.matches()) {
                return new String[]{m.group(1), DEFAULT_VERSION, m.group(2)};
            }
            return new String[]{jarName, DEFAULT_VERSION};
        }
        StringBuffer v = new StringBuffer();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        NameVersionTypeExtractor.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    NameVersionTypeExtractor.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                NameVersionTypeExtractor.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }
}

