/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.fileinstall.impl;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.camunda.bpm.extension.osgi.fileinstall.impl.util.NameVersionTypeExtractor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BpmnTransformer {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory tf = TransformerFactory.newInstance();

    public void transform(URL url, OutputStream os) throws Exception {
        Object e;
        Document doc = this.parse(url);
        String name = url.getPath();
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String[] str = NameVersionTypeExtractor.extractNameVersionType(name);
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "2");
        m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
        m.getMainAttributes().putValue("Bundle-Version", str[1]);
        m.getMainAttributes().putValue("Process-Definitions", "OSGI-INF/processes/");
        NodeList l = doc.getElementsByTagName("manifest");
        if (l != null) {
            for (int i = 0; i < l.getLength(); ++i) {
                e = (Element)l.item(i);
                String text = e.getTextContent();
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(text.trim().getBytes()));
                Set<String> en = props.stringPropertyNames();
                for (String k : en) {
                    String v = props.getProperty(k);
                    m.getMainAttributes().putValue(k, v);
                }
                e.getParentNode().removeChild((Node)e);
            }
        }
        JarOutputStream out = new JarOutputStream(os);
        e = new ZipEntry("META-INF/MANIFEST.MF");
        out.putNextEntry((ZipEntry)e);
        m.write(out);
        out.closeEntry();
        e = new ZipEntry("OSGI-INF/");
        out.putNextEntry((ZipEntry)e);
        String processDefDir = m.getMainAttributes().getValue("Process-Definitions");
        e = new ZipEntry(processDefDir);
        out.putNextEntry((ZipEntry)e);
        out.closeEntry();
        e = new ZipEntry(processDefDir + name);
        out.putNextEntry((ZipEntry)e);
        tf.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        out.closeEntry();
        out.close();
    }

    private Document parse(URL url) throws Exception {
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(url.toString());
    }
}

