/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.fileinstall.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.extension.osgi.fileinstall.impl.BpmnTransformer;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class BpmnURLHandler
extends AbstractURLStreamHandlerService {
    private static Logger logger = Logger.getLogger(BpmnURLHandler.class.getName());
    private static String SYNTAX = "bpmn: bpmn-xml-uri";
    private URL bpmnXmlURL;

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: " + SYNTAX);
        }
        this.bpmnXmlURL = new URL(url.getPath());
        logger.log(Level.FINE, "BPMN xml URL is: [" + this.bpmnXmlURL + "]");
        return new Connection(url);
    }

    public URL getBpmnXmlURL() {
        return this.bpmnXmlURL;
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                new BpmnTransformer().transform(BpmnURLHandler.this.bpmnXmlURL, os);
                os.close();
                return new ByteArrayInputStream(os.toByteArray());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error opening spring xml url", e);
                throw (IOException)new IOException("Error opening spring xml url").initCause(e);
            }
        }
    }
}

