/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.application;

import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.impl.javax.el.ELResolver;
import org.camunda.bpm.extension.osgi.application.impl.BlueprintBundleLocalELResolver;
import org.camunda.bpm.extension.osgi.application.impl.OSGiProcessApplicationReference;
import org.camunda.bpm.extension.osgi.classloading.BundleDelegatingClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class OSGiProcessApplication
extends AbstractProcessApplication {
    private Bundle bundle;
    private BundleDelegatingClassLoader bundleDelegatingCL;
    private ProcessApplicationReference reference;
    private BlueprintContainer blueprintContainer;

    public OSGiProcessApplication(Bundle bundle, BlueprintContainer blueprintContainer) {
        this.bundle = bundle;
        this.blueprintContainer = blueprintContainer;
        this.bundleDelegatingCL = new BundleDelegatingClassLoader(bundle);
    }

    public ProcessApplicationReference getReference() {
        if (this.reference == null) {
            this.reference = new OSGiProcessApplicationReference((ProcessApplicationInterface)this, this.getName());
        }
        return this.reference;
    }

    protected String autodetectProcessApplicationName() {
        return this.getBundle().getSymbolicName();
    }

    public ClassLoader getProcessApplicationClassloader() {
        return this.bundleDelegatingCL;
    }

    protected ELResolver initProcessApplicationElResolver() {
        BlueprintBundleLocalELResolver elResolver = new BlueprintBundleLocalELResolver();
        elResolver.setBlueprintContainer(this.blueprintContainer);
        return elResolver;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

