/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.extension.osgi.internal.ProcessDefintionChecker;
import org.camunda.bpm.extension.osgi.internal.impl.ProcessDefinitionCheckerImpl;
import org.camunda.bpm.extension.osgi.internal.impl.ProcessDefinitionDeployerImpl;
import org.camunda.bpm.extension.osgi.scripting.impl.ScriptEngineBundleTrackerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Extender
implements ServiceTrackerCustomizer {
    private final BundleContext context;
    private final BundleTracker bundleTracker;
    private final ServiceTracker engineServiceTracker;
    private final ProcessDefintionChecker procDefChecker;

    public Extender(BundleContext context) {
        this.context = context;
        this.engineServiceTracker = new ServiceTracker(context, ProcessEngine.class.getName(), (ServiceTrackerCustomizer)this);
        this.procDefChecker = new ProcessDefinitionCheckerImpl(new ProcessDefinitionDeployerImpl(this.engineServiceTracker));
        this.bundleTracker = new BundleTracker(context, 44, (BundleTrackerCustomizer)new ScriptEngineBundleTrackerCustomizer(this.procDefChecker));
    }

    public void open() {
        this.engineServiceTracker.open();
    }

    public void close() {
        this.engineServiceTracker.close();
    }

    public Object addingService(ServiceReference reference) {
        new Thread(){

            @Override
            public void run() {
                Extender.this.bundleTracker.open();
            }
        }.start();
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
        if (this.engineServiceTracker.size() == 0) {
            this.bundleTracker.close();
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (event.getType() == 32) {
            this.procDefChecker.checkBundle(bundle);
        }
    }
}

