/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.blueprint;

import java.beans.FeatureDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.impl.javax.el.ELResolver;

public class BlueprintELResolver
extends ELResolver {
    private static final Logger LOGGER = Logger.getLogger(BlueprintELResolver.class.getName());
    private Map<String, JavaDelegate> delegateMap = new HashMap<String, JavaDelegate>();

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            String key = (String)property;
            for (String name : this.delegateMap.keySet()) {
                if (!name.equalsIgnoreCase(key)) continue;
                context.setPropertyResolved(true);
                return this.delegateMap.get(name);
            }
        }
        return null;
    }

    public void bindService(JavaDelegate delegate, Map<?, ?> props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        this.delegateMap.put(name, delegate);
        LOGGER.info("added service to delegate cache " + name);
    }

    public void unbindService(JavaDelegate delegate, Map<?, ?> props) {
        String name = (String)props.get("osgi.service.blueprint.compname");
        if (this.delegateMap.containsKey(name)) {
            this.delegateMap.remove(name);
        }
        LOGGER.info("removed service from delegate cache " + name);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    public Class<?> getCommonPropertyType(ELContext context, Object arg) {
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object arg) {
        return null;
    }

    public Class<?> getType(ELContext context, Object arg1, Object arg2) {
        return Object.class;
    }
}

