/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.engine;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.extension.osgi.classloading.BundleDelegatingClassLoader;
import org.camunda.bpm.extension.osgi.classloading.ClassLoaderWrapper;
import org.osgi.framework.Bundle;

public class ProcessEngineFactory {
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected Bundle bundle;
    protected ProcessEngine processEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        try {
            BundleDelegatingClassLoader cl = new BundleDelegatingClassLoader(this.bundle);
            Thread.currentThread().setContextClassLoader(new ClassLoaderWrapper(cl, ProcessEngineFactory.class.getClassLoader(), ProcessEngineConfiguration.class.getClassLoader(), previous));
            this.processEngineConfiguration.setClassLoader((ClassLoader)cl);
            this.processEngine = this.processEngineConfiguration.buildProcessEngine();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
    }

    public void destroy() {
        if (this.processEngine != null) {
            this.processEngine.close();
        }
    }

    public ProcessEngine getObject() {
        return this.processEngine;
    }

    public ProcessEngineConfiguration getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfiguration processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }
}

