/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.osgi.scripting.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.camunda.bpm.extension.osgi.scripting.impl.BundleScriptEngineResolver;
import org.osgi.framework.Bundle;

public class ScriptEngineBundleScanner {
    private static final String META_INF_SERVICES_DIR = "META-INF/services";
    private static final String SCRIPT_ENGINE_SERVICE_FILE = "javax.script.ScriptEngineFactory";
    private static final Logger LOGGER = Logger.getLogger(ScriptEngineBundleScanner.class.getName());
    private Map<Long, List<BundleScriptEngineResolver>> resolvers = new ConcurrentHashMap<Long, List<BundleScriptEngineResolver>>();

    public Bundle addBundle(Bundle bundle) {
        ArrayList<BundleScriptEngineResolver> r = new ArrayList<BundleScriptEngineResolver>();
        this.registerScriptEngines(bundle, r);
        for (BundleScriptEngineResolver service : r) {
            service.register();
        }
        this.resolvers.put(bundle.getBundleId(), r);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle) {
    }

    public void removedBundle(Bundle bundle) {
        List<BundleScriptEngineResolver> r = this.resolvers.remove(bundle.getBundleId());
        if (r != null) {
            for (BundleScriptEngineResolver service : r) {
                service.unregister();
            }
        }
    }

    protected void registerScriptEngines(Bundle bundle, List<BundleScriptEngineResolver> resolvers) {
        Enumeration scriptEnginesUrls = bundle.findEntries(META_INF_SERVICES_DIR, SCRIPT_ENGINE_SERVICE_FILE, false);
        if (scriptEnginesUrls == null) {
            return;
        }
        for (URL configURL : Collections.list(scriptEnginesUrls)) {
            LOGGER.info("Found ScriptEngineFactory in " + bundle.getSymbolicName());
            resolvers.add(new BundleScriptEngineResolver(bundle, configURL));
        }
    }

    public Map<Long, List<BundleScriptEngineResolver>> getResolvers() {
        return Collections.unmodifiableMap(this.resolvers);
    }
}

