/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.rest.variables;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.camunda.bpm.engine.variable.type.SerializableValueType;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.type.ValueTypeResolver;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0001H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0001H\u0002J%\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J$\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00172\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u001a\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\bJ(\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00172\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\b\u0001\u0012\u00020\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/camunda/bpm/extension/rest/variables/ValueMapper;", "", "processEngine", "Lorg/camunda/bpm/engine/ProcessEngine;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/camunda/bpm/engine/ProcessEngine;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "deserializeObjectValue", "Lorg/camunda/bpm/engine/variable/value/TypedValue;", "value", "fromUntypedValue", "Lorg/camunda/bpm/engine/rest/dto/VariableValueDto;", "getTypeName", "", "mapDto", "T", "dto", "deserializeValues", "", "(Lorg/camunda/bpm/engine/rest/dto/VariableValueDto;Z)Ljava/lang/Object;", "mapDtos", "Lorg/camunda/bpm/engine/variable/VariableMap;", "variables", "", "mapValue", "variableValue", "isTransient", "mapValues", "", "restoreObjectJsonIfNeeded", "serializeValue", "", "Lorg/camunda/bpm/engine/variable/value/SerializableValue;", "camunda-rest-client-spring-boot"})
public final class ValueMapper {
    @NotNull
    private final ProcessEngine processEngine;
    @NotNull
    private final ObjectMapper objectMapper;

    public ValueMapper(@NotNull ProcessEngine processEngine, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)processEngine, (String)"processEngine");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.processEngine = processEngine;
        this.objectMapper = objectMapper;
    }

    public /* synthetic */ ValueMapper(ProcessEngine processEngine, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ProcessEngine processEngine2 = ProcessEngines.getDefaultProcessEngine();
            Intrinsics.checkNotNullExpressionValue((Object)processEngine2, (String)"getDefaultProcessEngine()");
            processEngine = processEngine2;
        }
        if ((n & 2) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper();
        }
        this(processEngine, objectMapper);
    }

    @NotNull
    public final VariableValueDto mapValue(@Nullable Object variableValue, boolean isTransient) {
        VariableValueDto variableValueDto;
        if (variableValue == null) {
            TypedValue typedValue = Variables.untypedNullValue((boolean)isTransient);
            Intrinsics.checkNotNullExpressionValue((Object)typedValue, (String)"untypedNullValue(isTransient)");
            variableValueDto = this.mapValue(typedValue);
        } else {
            TypedValue typedValue = Variables.untypedValue((Object)variableValue, (boolean)isTransient);
            Intrinsics.checkNotNullExpressionValue((Object)typedValue, (String)"untypedValue(variableValue, isTransient)");
            variableValueDto = this.mapValue(typedValue);
        }
        return variableValueDto;
    }

    public static /* synthetic */ VariableValueDto mapValue$default(ValueMapper valueMapper, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return valueMapper.mapValue(object, bl);
    }

    @NotNull
    public final VariableValueDto mapValue(@NotNull TypedValue variableValue) {
        Intrinsics.checkNotNullParameter((Object)variableValue, (String)"variableValue");
        if (variableValue instanceof SerializableValue) {
            this.serializeValue((SerializableValue)variableValue);
        }
        VariableValueDto variableValueDto = VariableValueDto.fromTypedValue((TypedValue)variableValue, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)variableValueDto, (String)"fromTypedValue(variableValue, true)");
        return variableValueDto;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, VariableValueDto> mapValues(@NotNull Map<String, ? extends Object> variables2) {
        Map map;
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        if (variables2 instanceof VariableMap) {
            void $this$mapTo$iv$iv;
            Map<String, ? extends Object> $this$map$iv = variables2;
            boolean $i$f$map = false;
            Map<String, ? extends Object> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_12 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_12.entrySet().iterator();
            while (iterator.hasNext()) {
                void it2;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object k = it2.getKey();
                TypedValue typedValue = ((VariableMap)variables2).getValueTyped((String)it2.getKey());
                Intrinsics.checkNotNullExpressionValue((Object)typedValue, (String)"variables.getValueTyped(it.key)");
                Pair pair = TuplesKt.to(k, (Object)this.mapValue(typedValue));
                collection.add(pair);
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            void $this$mapValuesTo$iv$iv;
            Map<String, ? extends Object> $this$mapValues$iv = variables2;
            boolean $i$f$mapValues = false;
            Map<String, ? extends Object> $this$mapTo$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map4 = map3;
                boolean bl3 = false;
                VariableValueDto variableValueDto = ValueMapper.mapValue$default(this, it.getValue(), false, 2, null);
                map4.put(k2, variableValueDto);
            }
            map = destination$iv$iv;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final VariableMap mapDtos(@NotNull Map<String, ? extends VariableValueDto> variables2, boolean deserializeValues) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        VariableMap variableMap = Variables.createVariables();
        Intrinsics.checkNotNullExpressionValue((Object)variableMap, (String)"createVariables()");
        VariableMap result = variableMap;
        Map<String, ? extends VariableValueDto> $this$mapValues$iv = variables2;
        boolean $i$f$mapValues = false;
        Map<String, ? extends VariableValueDto> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            TypedValue value = (deserializeValues ? this.restoreObjectJsonIfNeeded((VariableValueDto)it.getValue()) : (VariableValueDto)it.getValue()).toTypedValue(this.processEngine, this.objectMapper);
            Map map4 = (Map)result;
            Object k3 = it.getKey();
            boolean bl3 = false;
            map4.put(k3, value);
            Unit unit = Unit.INSTANCE;
            map3.put(k2, unit);
        }
        return result;
    }

    public static /* synthetic */ VariableMap mapDtos$default(ValueMapper valueMapper, Map map, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return valueMapper.mapDtos(map, bl);
    }

    @Nullable
    public final <T> T mapDto(@NotNull VariableValueDto dto, boolean deserializeValues) {
        TypedValue typedValue;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        if (deserializeValues) {
            TypedValue typedValue2 = this.restoreObjectJsonIfNeeded(dto).toTypedValue(this.processEngine, this.objectMapper);
            Intrinsics.checkNotNullExpressionValue((Object)typedValue2, (String)"restoreObjectJsonIfNeeded(dto).toTypedValue(processEngine, objectMapper)");
            typedValue = this.deserializeObjectValue(typedValue2);
        } else {
            typedValue = dto.toTypedValue(this.processEngine, this.objectMapper);
        }
        return (T)typedValue;
    }

    public static /* synthetic */ Object mapDto$default(ValueMapper valueMapper, VariableValueDto variableValueDto, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return valueMapper.mapDto(variableValueDto, bl);
    }

    private final VariableValueDto restoreObjectJsonIfNeeded(VariableValueDto dto) {
        ValueTypeResolver valueTypeResolver = this.processEngine.getProcessEngineConfiguration().getValueTypeResolver();
        Intrinsics.checkNotNullExpressionValue((Object)valueTypeResolver, (String)"processEngine.processEngineConfiguration.valueTypeResolver");
        ValueTypeResolver valueTypeResolver2 = valueTypeResolver;
        ValueType valueType = valueTypeResolver2.typeForName(VariableValueDto.fromRestApiTypeName((String)dto.getType()));
        Intrinsics.checkNotNullExpressionValue((Object)valueType, (String)"valueTypeResolver.typeForName(VariableValueDto.fromRestApiTypeName(dto.type))");
        ValueType valueType2 = valueType;
        if (valueType2 instanceof SerializableValueType && dto.getValue() != null && !(dto.getValue() instanceof String) && dto.getValue() instanceof Map) {
            Object object = dto.getValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            }
            Map attributes = (Map)object;
            dto.setValue((Object)this.objectMapper.writeValueAsString((Object)attributes));
        }
        return dto;
    }

    private final VariableValueDto fromUntypedValue(Object value) {
        VariableValueDto variableValueDto = new VariableValueDto();
        boolean bl = false;
        boolean bl2 = false;
        VariableValueDto $this$fromUntypedValue_u24lambda_u2d3 = variableValueDto;
        boolean bl3 = false;
        $this$fromUntypedValue_u24lambda_u2d3.setType(this.getTypeName(value));
        $this$fromUntypedValue_u24lambda_u2d3.setValue(value);
        return variableValueDto;
    }

    private final String getTypeName(Object value) {
        String string;
        Object object = value;
        if ((((((object instanceof Boolean ? true : object instanceof Date) ? true : object instanceof Double) ? true : object instanceof Integer) ? true : object instanceof Long) ? true : object instanceof Short) ? true : object instanceof String) {
            String string2 = Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = object instanceof byte[] ? "Bytes" : "Object";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void serializeValue(SerializableValue variableValue) {
        if (variableValue.getValueSerialized() != null) return;
        if (!Intrinsics.areEqual((Object)variableValue.getSerializationDataFormat(), (Object)Variables.SerializationDataFormats.JSON.getName()) && variableValue.getSerializationDataFormat() != null) throw new IllegalArgumentException("Object value could not be serialized into '" + variableValue.getSerializationDataFormat() + "' and no serialized value has been provided for " + variableValue);
        if (!(variableValue instanceof ObjectValueImpl)) throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Only serialization of object values is supported. Please provide serialized value for ", (Object)variableValue));
        try {
            String serializedValue = this.objectMapper.writeValueAsString(((ObjectValueImpl)variableValue).getValue());
            ((ObjectValueImpl)variableValue).setSerializedValue(serializedValue);
            if (((ObjectValueImpl)variableValue).getSerializationDataFormat() == null) {
                ((ObjectValueImpl)variableValue).setSerializationDataFormat(Variables.SerializationDataFormats.JSON.getName());
            }
            ObjectValueImpl objectValueImpl = (ObjectValueImpl)variableValue;
            Object object = ((ObjectValueImpl)variableValue).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variableValue.value");
            objectValueImpl.setObjectTypeName(this.getTypeName(object));
            return;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Object value could not be serialized into '" + ((ObjectValueImpl)variableValue).getSerializationDataFormat() + '\'', e);
        }
    }

    private final TypedValue deserializeObjectValue(TypedValue value) {
        if (value instanceof SerializableValue && !((SerializableValue)value).isDeserialized()) {
            if (Intrinsics.areEqual((Object)((SerializableValue)value).getSerializationDataFormat(), (Object)Variables.SerializationDataFormats.JSON.getName()) || ((SerializableValue)value).getSerializationDataFormat() == null) {
                if (value instanceof ObjectValueImpl) {
                    Object object;
                    try {
                        Class<?> clazz = Class.forName(((ObjectValueImpl)value).getObjectTypeName());
                        object = this.objectMapper.readValue(((ObjectValueImpl)value).getValueSerialized(), clazz);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(Intrinsics.stringPlus((String)"Error deserializing value ", (Object)value), e);
                    }
                    Object object2 = object;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"try {\n            val clazz = Class.forName(value.objectTypeName)\n            objectMapper.readValue(value.valueSerialized, clazz)\n          } catch (e: Exception) {\n            throw IllegalStateException(\"Error deserializing value $value\", e)\n          }");
                    Object deserializedValue = object2;
                    return (TypedValue)new ObjectValueImpl(deserializedValue, ((ObjectValueImpl)value).getValueSerialized(), ((ObjectValueImpl)value).getSerializationDataFormat(), ((ObjectValueImpl)value).getObjectTypeName(), true);
                }
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Could not deserialize value ", (Object)value));
            }
            throw new IllegalStateException("Could not deserialize value " + value + ", only application/json de-serialization is supported.");
        }
        return value;
    }

    public ValueMapper() {
        this(null, null, 3, null);
    }
}

