/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.rest.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionQueryDto;
import org.camunda.bpm.extension.rest.adapter.ProcessDefinitionAdapter;
import org.camunda.bpm.extension.rest.adapter.ProcessDefinitionBean;
import org.camunda.bpm.extension.rest.client.RepositoryServiceClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/camunda/bpm/extension/rest/impl/query/DelegatingProcessDefinitionQuery;", "Lorg/camunda/bpm/engine/impl/ProcessDefinitionQueryImpl;", "repositoryServiceClient", "Lorg/camunda/bpm/extension/rest/client/RepositoryServiceClient;", "(Lorg/camunda/bpm/extension/rest/client/RepositoryServiceClient;)V", "count", "", "fillQueryDto", "Lorg/camunda/bpm/engine/rest/dto/repository/ProcessDefinitionQueryDto;", "list", "", "Lorg/camunda/bpm/engine/repository/ProcessDefinition;", "listPage", "firstResult", "", "maxResults", "singleResult", "camunda-rest-client-spring-boot"})
public final class DelegatingProcessDefinitionQuery
extends ProcessDefinitionQueryImpl {
    @NotNull
    private final RepositoryServiceClient repositoryServiceClient;

    public DelegatingProcessDefinitionQuery(@NotNull RepositoryServiceClient repositoryServiceClient) {
        Intrinsics.checkNotNullParameter((Object)repositoryServiceClient, (String)"repositoryServiceClient");
        this.repositoryServiceClient = repositoryServiceClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProcessDefinition> list() {
        void $this$mapTo$iv$iv;
        List<ProcessDefinitionDto> definitions = this.repositoryServiceClient.getProcessDefinitions(this.fillQueryDto(), this.firstResult, this.maxResults);
        Iterable $this$map$iv = definitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProcessDefinitionDto processDefinitionDto = (ProcessDefinitionDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProcessDefinitionAdapter processDefinitionAdapter = new ProcessDefinitionAdapter(ProcessDefinitionBean.Companion.fromDto((ProcessDefinitionDto)it));
            collection.add(processDefinitionAdapter);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProcessDefinition> listPage(int firstResult, int maxResults) {
        void $this$mapTo$iv$iv;
        List<ProcessDefinitionDto> definitions = this.repositoryServiceClient.getProcessDefinitions(this.fillQueryDto(), firstResult, maxResults);
        Iterable $this$map$iv = definitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProcessDefinitionDto processDefinitionDto = (ProcessDefinitionDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProcessDefinitionAdapter processDefinitionAdapter = new ProcessDefinitionAdapter(ProcessDefinitionBean.Companion.fromDto((ProcessDefinitionDto)it));
            collection.add(processDefinitionAdapter);
        }
        return (List)destination$iv$iv;
    }

    public long count() {
        CountResultDto count = this.repositoryServiceClient.countProcessDefinitions(this.fillQueryDto(), this.firstResult, this.maxResults);
        return count.getCount();
    }

    @Nullable
    public ProcessDefinition singleResult() {
        ProcessDefinition processDefinition;
        List<ProcessDefinition> results = this.list();
        if (results.size() == 1) {
            processDefinition = results.get(0);
        } else {
            if (results.size() > 1) {
                throw new ProcessEngineException("Query return " + results.size() + " results instead of expected maximum 1");
            }
            processDefinition = null;
        }
        return processDefinition;
    }

    private final ProcessDefinitionQueryDto fillQueryDto() {
        String[] stringArray;
        ProcessDefinitionQueryDto queryDto = new ProcessDefinitionQueryDto();
        queryDto.setIncludeProcessDefinitionsWithoutTenantId(Boolean.valueOf(this.includeDefinitionsWithoutTenantId));
        if (this.suspensionState != null) {
            queryDto.setActive(Boolean.valueOf(Intrinsics.areEqual((Object)this.suspensionState, (Object)SuspensionState.ACTIVE)));
            queryDto.setSuspended(Boolean.valueOf(Intrinsics.areEqual((Object)this.suspensionState, (Object)SuspensionState.SUSPENDED)));
        }
        queryDto.setCategory(this.category);
        queryDto.setCategoryLike(this.categoryLike);
        queryDto.setDeploymentId(this.deploymentId);
        queryDto.setIncidentId(this.incidentId);
        queryDto.setIncidentMessage(this.incidentMessage);
        queryDto.setIncidentMessageLike(this.incidentMessageLike);
        queryDto.setIncidentType(this.incidentType);
        queryDto.setKey(this.key);
        queryDto.setKeyLike(this.keyLike);
        if (this.keys != null) {
            stringArray = this.keys;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"this.keys");
            queryDto.setKeysIn(ArraysKt.toList((Object[])stringArray));
        }
        queryDto.setLatestVersion(Boolean.valueOf(this.latest));
        queryDto.setName(this.name);
        queryDto.setNameLike(this.nameLike);
        queryDto.setNotStartableInTasklist(Boolean.valueOf(this.isNotStartableInTasklist));
        queryDto.setProcessDefinitionId(this.id);
        if (this.ids != null) {
            stringArray = this.ids;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"this.ids");
            queryDto.setProcessDefinitionIdIn(ArraysKt.toList((Object[])stringArray));
        }
        queryDto.setResourceName(this.resourceName);
        queryDto.setResourceNameLike(this.resourceNameLike);
        queryDto.setStartableBy(this.authorizationUserId);
        queryDto.setStartablePermissionCheck(Boolean.valueOf(this.startablePermissionCheck));
        if (this.isTenantIdSet) {
            if (this.tenantIds != null) {
                stringArray = this.tenantIds;
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"this.tenantIds");
                queryDto.setTenantIdIn(ArraysKt.toList((Object[])stringArray));
            } else {
                queryDto.setWithoutTenantId(Boolean.valueOf(true));
            }
        }
        queryDto.setVersion(this.version);
        queryDto.setVersionTag(this.versionTag);
        queryDto.setVersionTagLike(this.versionTagLike);
        return queryDto;
    }
}

