/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.actuator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class JobExecutorHealthIndicator
extends AbstractHealthIndicator {
    private final JobExecutor jobExecutor;

    public JobExecutorHealthIndicator(JobExecutor jobExecutor) {
        this.jobExecutor = Objects.requireNonNull(jobExecutor);
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        boolean active = this.jobExecutor.isActive();
        builder = active ? builder.up() : builder.down();
        builder.withDetail("jobExecutor", (Object)Details.from(this.jobExecutor));
    }

    public static final class Details {
        private final String name;
        private final String lockOwner;
        private final int lockTimeInMillis;
        private final int maxJobsPerAcquisition;
        private final int waitTimeInMillis;
        private final Set<String> processEngineNames;

        private static Details from(JobExecutor jobExecutor) {
            DetailsBuilder builder = Details.builder().name(jobExecutor.getName()).lockOwner(jobExecutor.getLockOwner()).lockTimeInMillis(jobExecutor.getLockTimeInMillis()).maxJobsPerAcquisition(jobExecutor.getMaxJobsPerAcquisition()).waitTimeInMillis(jobExecutor.getWaitTimeInMillis());
            for (ProcessEngineImpl processEngineImpl : jobExecutor.getProcessEngines()) {
                builder.processEngineName(processEngineImpl.getName());
            }
            return builder.build();
        }

        Details(String name, String lockOwner, int lockTimeInMillis, int maxJobsPerAcquisition, int waitTimeInMillis, Set<String> processEngineNames) {
            this.name = name;
            this.lockOwner = lockOwner;
            this.lockTimeInMillis = lockTimeInMillis;
            this.maxJobsPerAcquisition = maxJobsPerAcquisition;
            this.waitTimeInMillis = waitTimeInMillis;
            this.processEngineNames = processEngineNames;
        }

        public static DetailsBuilder builder() {
            return new DetailsBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public int getLockTimeInMillis() {
            return this.lockTimeInMillis;
        }

        public int getMaxJobsPerAcquisition() {
            return this.maxJobsPerAcquisition;
        }

        public int getWaitTimeInMillis() {
            return this.waitTimeInMillis;
        }

        public Set<String> getProcessEngineNames() {
            return this.processEngineNames;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Details)) {
                return false;
            }
            Details other = (Details)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$lockOwner = this.getLockOwner();
            String other$lockOwner = other.getLockOwner();
            if (this$lockOwner == null ? other$lockOwner != null : !this$lockOwner.equals(other$lockOwner)) {
                return false;
            }
            if (this.getLockTimeInMillis() != other.getLockTimeInMillis()) {
                return false;
            }
            if (this.getMaxJobsPerAcquisition() != other.getMaxJobsPerAcquisition()) {
                return false;
            }
            if (this.getWaitTimeInMillis() != other.getWaitTimeInMillis()) {
                return false;
            }
            Set<String> this$processEngineNames = this.getProcessEngineNames();
            Set<String> other$processEngineNames = other.getProcessEngineNames();
            return !(this$processEngineNames == null ? other$processEngineNames != null : !((Object)this$processEngineNames).equals(other$processEngineNames));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $lockOwner = this.getLockOwner();
            result = result * 59 + ($lockOwner == null ? 43 : $lockOwner.hashCode());
            result = result * 59 + this.getLockTimeInMillis();
            result = result * 59 + this.getMaxJobsPerAcquisition();
            result = result * 59 + this.getWaitTimeInMillis();
            Set<String> $processEngineNames = this.getProcessEngineNames();
            result = result * 59 + ($processEngineNames == null ? 43 : ((Object)$processEngineNames).hashCode());
            return result;
        }

        public String toString() {
            return "JobExecutorHealthIndicator.Details(name=" + this.getName() + ", lockOwner=" + this.getLockOwner() + ", lockTimeInMillis=" + this.getLockTimeInMillis() + ", maxJobsPerAcquisition=" + this.getMaxJobsPerAcquisition() + ", waitTimeInMillis=" + this.getWaitTimeInMillis() + ", processEngineNames=" + this.getProcessEngineNames() + ")";
        }

        public static class DetailsBuilder {
            private String name;
            private String lockOwner;
            private int lockTimeInMillis;
            private int maxJobsPerAcquisition;
            private int waitTimeInMillis;
            private ArrayList<String> processEngineNames;

            DetailsBuilder() {
            }

            public DetailsBuilder name(String name) {
                this.name = name;
                return this;
            }

            public DetailsBuilder lockOwner(String lockOwner) {
                this.lockOwner = lockOwner;
                return this;
            }

            public DetailsBuilder lockTimeInMillis(int lockTimeInMillis) {
                this.lockTimeInMillis = lockTimeInMillis;
                return this;
            }

            public DetailsBuilder maxJobsPerAcquisition(int maxJobsPerAcquisition) {
                this.maxJobsPerAcquisition = maxJobsPerAcquisition;
                return this;
            }

            public DetailsBuilder waitTimeInMillis(int waitTimeInMillis) {
                this.waitTimeInMillis = waitTimeInMillis;
                return this;
            }

            public DetailsBuilder processEngineName(String processEngineName) {
                if (this.processEngineNames == null) {
                    this.processEngineNames = new ArrayList();
                }
                this.processEngineNames.add(processEngineName);
                return this;
            }

            public DetailsBuilder processEngineNames(Collection<? extends String> processEngineNames) {
                if (this.processEngineNames == null) {
                    this.processEngineNames = new ArrayList();
                }
                this.processEngineNames.addAll(processEngineNames);
                return this;
            }

            public DetailsBuilder clearProcessEngineNames() {
                if (this.processEngineNames != null) {
                    this.processEngineNames.clear();
                }
                return this;
            }

            public Details build() {
                Set<Object> processEngineNames;
                switch (this.processEngineNames == null ? 0 : this.processEngineNames.size()) {
                    case 0: {
                        processEngineNames = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        processEngineNames = Collections.singleton(this.processEngineNames.get(0));
                        break;
                    }
                    default: {
                        processEngineNames = new LinkedHashSet(this.processEngineNames.size() < 0x40000000 ? 1 + this.processEngineNames.size() + (this.processEngineNames.size() - 3) / 3 : Integer.MAX_VALUE);
                        processEngineNames.addAll(this.processEngineNames);
                        processEngineNames = Collections.unmodifiableSet(processEngineNames);
                    }
                }
                return new Details(this.name, this.lockOwner, this.lockTimeInMillis, this.maxJobsPerAcquisition, this.waitTimeInMillis, processEngineNames);
            }

            public String toString() {
                return "JobExecutorHealthIndicator.Details.DetailsBuilder(name=" + this.name + ", lockOwner=" + this.lockOwner + ", lockTimeInMillis=" + this.lockTimeInMillis + ", maxJobsPerAcquisition=" + this.maxJobsPerAcquisition + ", waitTimeInMillis=" + this.waitTimeInMillis + ", processEngineNames=" + this.processEngineNames + ")";
            }
        }
    }
}

