/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl;

import java.util.List;
import org.camunda.bpm.engine.impl.jobexecutor.CallerRunsRejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.engine.spring.components.jobexecutor.SpringJobExecutor;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaJobConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.camunda.bpm.spring.boot.starter.event.JobExecutorStartingEventListener;
import org.camunda.bpm.spring.boot.starter.util.CamundaSpringBootUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJobConfiguration
extends AbstractCamundaConfiguration
implements CamundaJobConfiguration {
    @Autowired
    protected JobExecutor jobExecutor;
    @Autowired(required=false)
    protected List<JobHandler<?>> customJobHandlers;

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        this.configureJobExecutor(configuration);
        this.registerCustomJobHandlers(configuration);
    }

    protected void registerCustomJobHandlers(SpringProcessEngineConfiguration configuration) {
        configuration.setCustomJobHandlers(CamundaSpringBootUtil.join(configuration.getCustomJobHandlers(), this.customJobHandlers));
        for (JobHandler jobHandler : configuration.getCustomJobHandlers()) {
            this.logger.info("Register Custom JobHandler: '{}'", (Object)jobHandler.getType());
        }
    }

    protected void configureJobExecutor(SpringProcessEngineConfiguration configuration) {
        configuration.setJobExecutorActivate(false);
        configuration.setJobExecutorDeploymentAware(this.camundaBpmProperties.getJobExecution().isDeploymentAware());
        configuration.setJobExecutor(this.jobExecutor);
    }

    public static class JobConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={TaskExecutor.class})
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static TaskExecutor taskExecutor(@Value(value="${camunda.bpm.job-execution.core-pool-size:1}") int corePoolSize) {
            ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            if (corePoolSize > 1) {
                threadPoolTaskExecutor.setCorePoolSize(corePoolSize);
            }
            AbstractCamundaConfiguration.LOG.configureJobExecutorPool(corePoolSize);
            return threadPoolTaskExecutor;
        }

        @Bean
        @ConditionalOnMissingBean(value={JobExecutor.class})
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static JobExecutor jobExecutor(TaskExecutor taskExecutor) {
            SpringJobExecutor springJobExecutor = new SpringJobExecutor();
            springJobExecutor.setTaskExecutor(taskExecutor);
            springJobExecutor.setRejectedJobsHandler((RejectedJobsHandler)new CallerRunsRejectedJobsHandler());
            return springJobExecutor;
        }

        @Bean
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnBean(value={JobExecutor.class})
        public static JobExecutorStartingEventListener jobExecutorStartingEventListener() {
            return new JobExecutorStartingEventListener();
        }
    }
}

