/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.property;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.camunda.bpm.spring.boot.starter.property.AdminUserProperty;
import org.camunda.bpm.spring.boot.starter.property.ApplicationProperty;
import org.camunda.bpm.spring.boot.starter.property.AuthorizationProperty;
import org.camunda.bpm.spring.boot.starter.property.DatabaseProperty;
import org.camunda.bpm.spring.boot.starter.property.Defaults;
import org.camunda.bpm.spring.boot.starter.property.FilterProperty;
import org.camunda.bpm.spring.boot.starter.property.GenericProperties;
import org.camunda.bpm.spring.boot.starter.property.JobExecutionProperty;
import org.camunda.bpm.spring.boot.starter.property.JpaProperty;
import org.camunda.bpm.spring.boot.starter.property.MetricsProperty;
import org.camunda.bpm.spring.boot.starter.property.WebappProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="camunda.bpm")
public class CamundaBpmProperties {
    public static final String PREFIX = "camunda.bpm";
    public static final String[] DEFAULT_BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    public static final String[] DEFAULT_CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn11.xml", "cmmn10.xml", "cmmn"};
    public static final String[] DEFAULT_DMN_RESOURCE_SUFFIXES = new String[]{"dmn11.xml", "dmn"};
    private String processEngineName = "default";
    private String historyLevel;
    private String historyLevelDefault;
    private boolean autoDeploymentEnabled = true;
    private String[] deploymentResourcePattern = CamundaBpmProperties.initDeploymentResourcePattern();
    private String defaultSerializationFormat = Defaults.INSTANCE.getDefaultSerializationFormat();
    private URL licenseFile;
    @NestedConfigurationProperty
    private MetricsProperty metrics = new MetricsProperty();
    @NestedConfigurationProperty
    private DatabaseProperty database = new DatabaseProperty();
    @NestedConfigurationProperty
    private JpaProperty jpa = new JpaProperty();
    @NestedConfigurationProperty
    private JobExecutionProperty jobExecution = new JobExecutionProperty();
    @NestedConfigurationProperty
    private WebappProperty webapp = new WebappProperty();
    @NestedConfigurationProperty
    private ApplicationProperty application = new ApplicationProperty();
    @NestedConfigurationProperty
    private AuthorizationProperty authorization = new AuthorizationProperty();
    @NestedConfigurationProperty
    private GenericProperties genericProperties = new GenericProperties();
    @NestedConfigurationProperty
    private AdminUserProperty adminUser = new AdminUserProperty();
    @NestedConfigurationProperty
    private FilterProperty filter = new FilterProperty();

    static String[] initDeploymentResourcePattern() {
        HashSet<String> suffixes = new HashSet<String>();
        suffixes.addAll(Arrays.asList(DEFAULT_DMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(DEFAULT_BPMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(DEFAULT_CMMN_RESOURCE_SUFFIXES));
        HashSet<String> patterns = new HashSet<String>();
        for (String suffix : suffixes) {
            patterns.add(String.format("%s**/*.%s", "classpath*:", suffix));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public String getHistoryLevel() {
        return this.historyLevel;
    }

    public String getHistoryLevelDefault() {
        return this.historyLevelDefault;
    }

    public boolean isAutoDeploymentEnabled() {
        return this.autoDeploymentEnabled;
    }

    public String[] getDeploymentResourcePattern() {
        return this.deploymentResourcePattern;
    }

    public String getDefaultSerializationFormat() {
        return this.defaultSerializationFormat;
    }

    public URL getLicenseFile() {
        return this.licenseFile;
    }

    public MetricsProperty getMetrics() {
        return this.metrics;
    }

    public DatabaseProperty getDatabase() {
        return this.database;
    }

    public JpaProperty getJpa() {
        return this.jpa;
    }

    public JobExecutionProperty getJobExecution() {
        return this.jobExecution;
    }

    public WebappProperty getWebapp() {
        return this.webapp;
    }

    public ApplicationProperty getApplication() {
        return this.application;
    }

    public AuthorizationProperty getAuthorization() {
        return this.authorization;
    }

    public GenericProperties getGenericProperties() {
        return this.genericProperties;
    }

    public AdminUserProperty getAdminUser() {
        return this.adminUser;
    }

    public FilterProperty getFilter() {
        return this.filter;
    }

    public void setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
    }

    public void setHistoryLevel(String historyLevel) {
        this.historyLevel = historyLevel;
    }

    public void setHistoryLevelDefault(String historyLevelDefault) {
        this.historyLevelDefault = historyLevelDefault;
    }

    public void setAutoDeploymentEnabled(boolean autoDeploymentEnabled) {
        this.autoDeploymentEnabled = autoDeploymentEnabled;
    }

    public void setDeploymentResourcePattern(String[] deploymentResourcePattern) {
        this.deploymentResourcePattern = deploymentResourcePattern;
    }

    public void setDefaultSerializationFormat(String defaultSerializationFormat) {
        this.defaultSerializationFormat = defaultSerializationFormat;
    }

    public void setLicenseFile(URL licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setMetrics(MetricsProperty metrics) {
        this.metrics = metrics;
    }

    public void setDatabase(DatabaseProperty database) {
        this.database = database;
    }

    public void setJpa(JpaProperty jpa) {
        this.jpa = jpa;
    }

    public void setJobExecution(JobExecutionProperty jobExecution) {
        this.jobExecution = jobExecution;
    }

    public void setWebapp(WebappProperty webapp) {
        this.webapp = webapp;
    }

    public void setApplication(ApplicationProperty application) {
        this.application = application;
    }

    public void setAuthorization(AuthorizationProperty authorization) {
        this.authorization = authorization;
    }

    public void setGenericProperties(GenericProperties genericProperties) {
        this.genericProperties = genericProperties;
    }

    public void setAdminUser(AdminUserProperty adminUser) {
        this.adminUser = adminUser;
    }

    public void setFilter(FilterProperty filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamundaBpmProperties)) {
            return false;
        }
        CamundaBpmProperties other = (CamundaBpmProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$processEngineName = this.getProcessEngineName();
        String other$processEngineName = other.getProcessEngineName();
        if (this$processEngineName == null ? other$processEngineName != null : !this$processEngineName.equals(other$processEngineName)) {
            return false;
        }
        String this$historyLevel = this.getHistoryLevel();
        String other$historyLevel = other.getHistoryLevel();
        if (this$historyLevel == null ? other$historyLevel != null : !this$historyLevel.equals(other$historyLevel)) {
            return false;
        }
        String this$historyLevelDefault = this.getHistoryLevelDefault();
        String other$historyLevelDefault = other.getHistoryLevelDefault();
        if (this$historyLevelDefault == null ? other$historyLevelDefault != null : !this$historyLevelDefault.equals(other$historyLevelDefault)) {
            return false;
        }
        if (this.isAutoDeploymentEnabled() != other.isAutoDeploymentEnabled()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDeploymentResourcePattern(), other.getDeploymentResourcePattern())) {
            return false;
        }
        String this$defaultSerializationFormat = this.getDefaultSerializationFormat();
        String other$defaultSerializationFormat = other.getDefaultSerializationFormat();
        if (this$defaultSerializationFormat == null ? other$defaultSerializationFormat != null : !this$defaultSerializationFormat.equals(other$defaultSerializationFormat)) {
            return false;
        }
        URL this$licenseFile = this.getLicenseFile();
        URL other$licenseFile = other.getLicenseFile();
        if (this$licenseFile == null ? other$licenseFile != null : !((Object)this$licenseFile).equals(other$licenseFile)) {
            return false;
        }
        MetricsProperty this$metrics = this.getMetrics();
        MetricsProperty other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        DatabaseProperty this$database = this.getDatabase();
        DatabaseProperty other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        JpaProperty this$jpa = this.getJpa();
        JpaProperty other$jpa = other.getJpa();
        if (this$jpa == null ? other$jpa != null : !((Object)this$jpa).equals(other$jpa)) {
            return false;
        }
        JobExecutionProperty this$jobExecution = this.getJobExecution();
        JobExecutionProperty other$jobExecution = other.getJobExecution();
        if (this$jobExecution == null ? other$jobExecution != null : !((Object)this$jobExecution).equals(other$jobExecution)) {
            return false;
        }
        WebappProperty this$webapp = this.getWebapp();
        WebappProperty other$webapp = other.getWebapp();
        if (this$webapp == null ? other$webapp != null : !((Object)this$webapp).equals(other$webapp)) {
            return false;
        }
        ApplicationProperty this$application = this.getApplication();
        ApplicationProperty other$application = other.getApplication();
        if (this$application == null ? other$application != null : !((Object)this$application).equals(other$application)) {
            return false;
        }
        AuthorizationProperty this$authorization = this.getAuthorization();
        AuthorizationProperty other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !((Object)this$authorization).equals(other$authorization)) {
            return false;
        }
        GenericProperties this$genericProperties = this.getGenericProperties();
        GenericProperties other$genericProperties = other.getGenericProperties();
        if (this$genericProperties == null ? other$genericProperties != null : !((Object)this$genericProperties).equals(other$genericProperties)) {
            return false;
        }
        AdminUserProperty this$adminUser = this.getAdminUser();
        AdminUserProperty other$adminUser = other.getAdminUser();
        if (this$adminUser == null ? other$adminUser != null : !((Object)this$adminUser).equals(other$adminUser)) {
            return false;
        }
        FilterProperty this$filter = this.getFilter();
        FilterProperty other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CamundaBpmProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $processEngineName = this.getProcessEngineName();
        result = result * 59 + ($processEngineName == null ? 43 : $processEngineName.hashCode());
        String $historyLevel = this.getHistoryLevel();
        result = result * 59 + ($historyLevel == null ? 43 : $historyLevel.hashCode());
        String $historyLevelDefault = this.getHistoryLevelDefault();
        result = result * 59 + ($historyLevelDefault == null ? 43 : $historyLevelDefault.hashCode());
        result = result * 59 + (this.isAutoDeploymentEnabled() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getDeploymentResourcePattern());
        String $defaultSerializationFormat = this.getDefaultSerializationFormat();
        result = result * 59 + ($defaultSerializationFormat == null ? 43 : $defaultSerializationFormat.hashCode());
        URL $licenseFile = this.getLicenseFile();
        result = result * 59 + ($licenseFile == null ? 43 : ((Object)$licenseFile).hashCode());
        MetricsProperty $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        DatabaseProperty $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        JpaProperty $jpa = this.getJpa();
        result = result * 59 + ($jpa == null ? 43 : ((Object)$jpa).hashCode());
        JobExecutionProperty $jobExecution = this.getJobExecution();
        result = result * 59 + ($jobExecution == null ? 43 : ((Object)$jobExecution).hashCode());
        WebappProperty $webapp = this.getWebapp();
        result = result * 59 + ($webapp == null ? 43 : ((Object)$webapp).hashCode());
        ApplicationProperty $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : ((Object)$application).hashCode());
        AuthorizationProperty $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : ((Object)$authorization).hashCode());
        GenericProperties $genericProperties = this.getGenericProperties();
        result = result * 59 + ($genericProperties == null ? 43 : ((Object)$genericProperties).hashCode());
        AdminUserProperty $adminUser = this.getAdminUser();
        result = result * 59 + ($adminUser == null ? 43 : ((Object)$adminUser).hashCode());
        FilterProperty $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    public String toString() {
        return "CamundaBpmProperties(processEngineName=" + this.getProcessEngineName() + ", historyLevel=" + this.getHistoryLevel() + ", historyLevelDefault=" + this.getHistoryLevelDefault() + ", autoDeploymentEnabled=" + this.isAutoDeploymentEnabled() + ", deploymentResourcePattern=" + Arrays.deepToString(this.getDeploymentResourcePattern()) + ", defaultSerializationFormat=" + this.getDefaultSerializationFormat() + ", licenseFile=" + this.getLicenseFile() + ", metrics=" + this.getMetrics() + ", database=" + this.getDatabase() + ", jpa=" + this.getJpa() + ", jobExecution=" + this.getJobExecution() + ", webapp=" + this.getWebapp() + ", application=" + this.getApplication() + ", authorization=" + this.getAuthorization() + ", genericProperties=" + this.getGenericProperties() + ", adminUser=" + this.getAdminUser() + ", filter=" + this.getFilter() + ")";
    }
}

