/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.springframework.util.CollectionUtils;

public final class CamundaSpringBootUtil {
    public static <T> Optional<T> cast(Object obj, Class<T> type) {
        return Optional.ofNullable(obj).filter(type::isInstance).map(type::cast);
    }

    public static SpringProcessEngineConfiguration springProcessEngineConfiguration() {
        SpringProcessEngineConfiguration configuration = new SpringProcessEngineConfiguration();
        return CamundaSpringBootUtil.init(configuration);
    }

    public static SpringProcessEngineConfiguration init(SpringProcessEngineConfiguration configuration) {
        if (configuration.getProcessEnginePlugins() == null) {
            configuration.setProcessEnginePlugins(new ArrayList());
        }
        if (configuration.getBatchHandlers() == null) {
            configuration.setBatchHandlers(new HashMap());
        }
        if (configuration.getBeans() == null) {
            configuration.setBeans(new HashMap());
        }
        if (configuration.getCommandCheckers() == null) {
            configuration.setCommandCheckers(new ArrayList());
        }
        if (configuration.getCustomPostBPMNParseListeners() == null) {
            configuration.setCustomPostBPMNParseListeners(new ArrayList());
        }
        return configuration;
    }

    public static Optional<ProcessEngineImpl> processEngineImpl(ProcessEngine processEngine) {
        return CamundaSpringBootUtil.cast(processEngine, ProcessEngineImpl.class);
    }

    public static Optional<SpringProcessEngineConfiguration> springProcessEngineConfiguration(ProcessEngineConfiguration configuration) {
        return CamundaSpringBootUtil.cast(configuration, SpringProcessEngineConfiguration.class);
    }

    public static SpringProcessEngineConfiguration get(ProcessEngine processEngine) {
        return (SpringProcessEngineConfiguration)processEngine.getProcessEngineConfiguration();
    }

    public static <T> List<T> join(List<? extends T> existing, List<? extends T> add) {
        ArrayList<Object> target = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(existing)) {
            target.addAll(existing);
        }
        if (!CollectionUtils.isEmpty(add)) {
            target.addAll(add);
        }
        return target;
    }

    private CamundaSpringBootUtil() {
    }
}

