/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.util;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.lang.StringUtils;
import org.camunda.bpm.spring.boot.starter.annotation.EnableProcessApplication;
import org.springframework.context.ApplicationContext;

public class GetProcessApplicationNameFromAnnotation
implements Supplier<Optional<String>>,
UnaryOperator<Optional<String>> {
    private final ApplicationContext applicationContext;
    public static Function<ApplicationContext, Optional<AnnotatedBean>> getAnnotatedBean = applicationContext -> {
        Map beans = Optional.ofNullable(applicationContext.getBeansWithAnnotation(EnableProcessApplication.class)).orElse(Collections.EMPTY_MAP);
        if (beans.size() > 1) {
            throw new IllegalStateException("requires exactly one bean to be annotated with @EnableProcessApplication, found: " + beans.keySet());
        }
        return beans.entrySet().stream().findFirst().map(e -> AnnotatedBean.of((String)e.getKey(), e.getValue()));
    };
    public static Function<EnableProcessApplication, Optional<String>> getAnnotationValue = annotation -> Optional.of(annotation).map(EnableProcessApplication::value).filter(StringUtils::isNotBlank);
    public static Function<AnnotatedBean, String> getName = pair -> Optional.of(pair.getAnnotation()).flatMap(getAnnotationValue).orElse(pair.getName());
    public static Function<ApplicationContext, Optional<String>> getProcessApplicationName = applicationContext -> getAnnotatedBean.apply((ApplicationContext)applicationContext).map(getName);

    public static GetProcessApplicationNameFromAnnotation processApplicationNameFromAnnotation(ApplicationContext applicationContext) {
        return new GetProcessApplicationNameFromAnnotation(applicationContext);
    }

    private GetProcessApplicationNameFromAnnotation(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Optional<String> get() {
        return getProcessApplicationName.apply(this.applicationContext);
    }

    @Override
    public Optional<String> apply(Optional<String> springApplicationName) {
        Optional<String> processApplicationName = getProcessApplicationName.apply(this.applicationContext);
        if (processApplicationName.isPresent()) {
            return processApplicationName;
        }
        if (springApplicationName.isPresent()) {
            return springApplicationName;
        }
        return Optional.empty();
    }

    public static final class AnnotatedBean {
        private final String name;
        private final EnableProcessApplication annotation;

        public static AnnotatedBean of(String name, Object instance) {
            return AnnotatedBean.of(name, instance.getClass().getAnnotation(EnableProcessApplication.class));
        }

        private AnnotatedBean(String name, EnableProcessApplication annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        public static AnnotatedBean of(String name, EnableProcessApplication annotation) {
            return new AnnotatedBean(name, annotation);
        }

        public String getName() {
            return this.name;
        }

        public EnableProcessApplication getAnnotation() {
            return this.annotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedBean)) {
                return false;
            }
            AnnotatedBean other = (AnnotatedBean)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            EnableProcessApplication this$annotation = this.getAnnotation();
            EnableProcessApplication other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            EnableProcessApplication $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public String toString() {
            return "GetProcessApplicationNameFromAnnotation.AnnotatedBean(name=" + this.getName() + ", annotation=" + this.getAnnotation() + ")";
        }
    }
}

