/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter;

import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.spring.ProcessEngineFactoryBean;
import org.camunda.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import org.camunda.bpm.spring.boot.starter.CamundaBpmActuatorConfiguration;
import org.camunda.bpm.spring.boot.starter.CamundaBpmConfiguration;
import org.camunda.bpm.spring.boot.starter.CamundaBpmPluginConfiguration;
import org.camunda.bpm.spring.boot.starter.event.ProcessApplicationEventPublisher;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.ManagementProperties;
import org.camunda.bpm.spring.boot.starter.util.CamundaBpmVersion;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={CamundaBpmProperties.class, ManagementProperties.class})
@Import(value={CamundaBpmConfiguration.class, CamundaBpmActuatorConfiguration.class, CamundaBpmPluginConfiguration.class, SpringProcessEngineServicesConfiguration.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
public class CamundaBpmAutoConfiguration {
    @Bean
    public ProcessEngineFactoryBean processEngineFactoryBean(ProcessEngineConfigurationImpl processEngineConfigurationImpl) {
        ProcessEngineFactoryBean factoryBean = new ProcessEngineFactoryBean();
        factoryBean.setProcessEngineConfiguration(processEngineConfigurationImpl);
        return factoryBean;
    }

    @Bean
    public CamundaBpmVersion camundaBpmVersion() {
        return new CamundaBpmVersion();
    }

    @Bean
    @Primary
    public CommandExecutor commandExecutorTxRequired(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getCommandExecutorTxRequired();
    }

    @Bean
    public CommandExecutor commandExecutorTxRequiresNew(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getCommandExecutorTxRequiresNew();
    }

    @Bean
    public CommandExecutor commandExecutorSchemaOperations(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getCommandExecutorSchemaOperations();
    }

    @Bean
    public ProcessApplicationEventPublisher processApplicationEventPublisher(ApplicationEventPublisher publisher) {
        return new ProcessApplicationEventPublisher(publisher);
    }
}

