/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.property;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.camunda.bpm.spring.boot.starter.property.AdminUserProperty;
import org.camunda.bpm.spring.boot.starter.property.ApplicationProperty;
import org.camunda.bpm.spring.boot.starter.property.AuthorizationProperty;
import org.camunda.bpm.spring.boot.starter.property.DatabaseProperty;
import org.camunda.bpm.spring.boot.starter.property.Defaults;
import org.camunda.bpm.spring.boot.starter.property.FilterProperty;
import org.camunda.bpm.spring.boot.starter.property.GenericProperties;
import org.camunda.bpm.spring.boot.starter.property.JobExecutionProperty;
import org.camunda.bpm.spring.boot.starter.property.JpaProperty;
import org.camunda.bpm.spring.boot.starter.property.MetricsProperty;
import org.camunda.bpm.spring.boot.starter.property.WebappProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="camunda.bpm")
public class CamundaBpmProperties {
    public static final String PREFIX = "camunda.bpm";
    public static final String[] DEFAULT_BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    public static final String[] DEFAULT_CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn11.xml", "cmmn10.xml", "cmmn"};
    public static final String[] DEFAULT_DMN_RESOURCE_SUFFIXES = new String[]{"dmn11.xml", "dmn"};
    private String processEngineName = "default";
    private String idGenerator = "simple";
    private String historyLevel;
    private String historyLevelDefault;
    private boolean autoDeploymentEnabled = true;
    private String[] deploymentResourcePattern = CamundaBpmProperties.initDeploymentResourcePattern();
    private String defaultSerializationFormat = Defaults.INSTANCE.getDefaultSerializationFormat();
    private URL licenseFile;
    @NestedConfigurationProperty
    private MetricsProperty metrics = new MetricsProperty();
    @NestedConfigurationProperty
    private DatabaseProperty database = new DatabaseProperty();
    @NestedConfigurationProperty
    private JpaProperty jpa = new JpaProperty();
    @NestedConfigurationProperty
    private JobExecutionProperty jobExecution = new JobExecutionProperty();
    @NestedConfigurationProperty
    private WebappProperty webapp = new WebappProperty();
    @NestedConfigurationProperty
    private ApplicationProperty application = new ApplicationProperty();
    @NestedConfigurationProperty
    private AuthorizationProperty authorization = new AuthorizationProperty();
    @NestedConfigurationProperty
    private GenericProperties genericProperties = new GenericProperties();
    @NestedConfigurationProperty
    private AdminUserProperty adminUser = new AdminUserProperty();
    @NestedConfigurationProperty
    private FilterProperty filter = new FilterProperty();

    static String[] initDeploymentResourcePattern() {
        HashSet<String> suffixes = new HashSet<String>();
        suffixes.addAll(Arrays.asList(DEFAULT_DMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(DEFAULT_BPMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(DEFAULT_CMMN_RESOURCE_SUFFIXES));
        HashSet<String> patterns = new HashSet<String>();
        for (String suffix : suffixes) {
            patterns.add(String.format("%s**/*.%s", "classpath*:", suffix));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public void setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
    }

    public String getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(String historyLevel) {
        this.historyLevel = historyLevel;
    }

    public String getHistoryLevelDefault() {
        return this.historyLevelDefault;
    }

    public void setHistoryLevelDefault(String historyLevelDefault) {
        this.historyLevelDefault = historyLevelDefault;
    }

    public boolean isAutoDeploymentEnabled() {
        return this.autoDeploymentEnabled;
    }

    public void setAutoDeploymentEnabled(boolean autoDeploymentEnabled) {
        this.autoDeploymentEnabled = autoDeploymentEnabled;
    }

    public String[] getDeploymentResourcePattern() {
        return this.deploymentResourcePattern;
    }

    public void setDeploymentResourcePattern(String[] deploymentResourcePattern) {
        this.deploymentResourcePattern = deploymentResourcePattern;
    }

    public String getDefaultSerializationFormat() {
        return this.defaultSerializationFormat;
    }

    public void setDefaultSerializationFormat(String defaultSerializationFormat) {
        this.defaultSerializationFormat = defaultSerializationFormat;
    }

    public URL getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(URL licenseFile) {
        this.licenseFile = licenseFile;
    }

    public MetricsProperty getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricsProperty metrics) {
        this.metrics = metrics;
    }

    public DatabaseProperty getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseProperty database) {
        this.database = database;
    }

    public JpaProperty getJpa() {
        return this.jpa;
    }

    public void setJpa(JpaProperty jpa) {
        this.jpa = jpa;
    }

    public JobExecutionProperty getJobExecution() {
        return this.jobExecution;
    }

    public void setJobExecution(JobExecutionProperty jobExecution) {
        this.jobExecution = jobExecution;
    }

    public WebappProperty getWebapp() {
        return this.webapp;
    }

    public void setWebapp(WebappProperty webapp) {
        this.webapp = webapp;
    }

    public ApplicationProperty getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationProperty application) {
        this.application = application;
    }

    public AuthorizationProperty getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(AuthorizationProperty authorization) {
        this.authorization = authorization;
    }

    public GenericProperties getGenericProperties() {
        return this.genericProperties;
    }

    public void setGenericProperties(GenericProperties genericProperties) {
        this.genericProperties = genericProperties;
    }

    public AdminUserProperty getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(AdminUserProperty adminUser) {
        this.adminUser = adminUser;
    }

    public FilterProperty getFilter() {
        return this.filter;
    }

    public void setFilter(FilterProperty filter) {
        this.filter = filter;
    }

    public String getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(String idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String toString() {
        return "CamundaBpmProperties [processEngineName=" + this.processEngineName + ", historyLevel=" + this.historyLevel + ", historyLevelDefault=" + this.historyLevelDefault + ", autoDeploymentEnabled=" + this.autoDeploymentEnabled + ", deploymentResourcePattern=" + Arrays.toString(this.deploymentResourcePattern) + ", defaultSerializationFormat=" + this.defaultSerializationFormat + ", licenseFile=" + this.licenseFile + ", metrics=" + this.metrics + ", database=" + this.database + ", jpa=" + this.jpa + ", jobExecution=" + this.jobExecution + ", webapp=" + this.webapp + ", application=" + this.application + ", authorization=" + this.authorization + ", genericProperties=" + this.genericProperties + ", adminUser=" + this.adminUser + ", filter=" + this.filter + ", idGenerator=" + this.idGenerator + "]";
    }
}

