/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.docs;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.camunda.bpm.swagger.docs.model.ParameterDescription;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.docs.model.RestOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class DocumentationYaml
implements Supplier<Map<Pair<String, String>, RestOperation>> {
    private static final Logger log = LoggerFactory.getLogger(DocumentationYaml.class);
    private final Map<Pair<String, String>, RestOperation> operations;

    public DocumentationYaml() {
        this("/camunda-rest-docs.yaml");
    }

    public DocumentationYaml(String yamlFile) {
        try (InputStream in = DocumentationYaml.class.getResourceAsStream(yamlFile);){
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(RestOperations.class));
            RestOperations items = (RestOperations)yaml.load(in);
            this.operations = items.getRestOperations().stream().collect(Collectors.groupingBy(p -> Pair.of((Object)DocumentationYaml.normalizePath(p.getPath()), (Object)p.getMethod()), Collectors.reducing(null, this::reduceDuplicateRestOperations)));
        }
    }

    @Override
    public Map<Pair<String, String>, RestOperation> get() {
        if (this.operations == null) {
            return Collections.emptyMap();
        }
        return this.operations;
    }

    public void print(Map<Pair<String, String>, RestOperation> ops) {
        ops.entrySet().stream().forEach(e -> {
            log.info("{} {}", ((Pair)e.getKey()).getLeft(), ((Pair)e.getKey()).getRight());
            this.print((RestOperation)e.getValue());
        });
    }

    private void print(RestOperation op) {
        log.info("--> {}: {}", (Object)op.getMethod(), (Object)op.getDescription());
    }

    public void info() {
        this.print(this.operations);
    }

    private RestOperation reduceDuplicateRestOperations(RestOperation acc, RestOperation elem) {
        if (acc == null) {
            return elem;
        }
        log.info("duplicate entry for " + acc.getPath() + "(" + acc.getMethod() + ") - trying to merge");
        this.expandAttr(acc, elem, RestOperation::getPathParameters);
        this.expandAttr(acc, elem, RestOperation::getQueryParameters);
        this.expandAttr(acc, elem, RestOperation::getResponseCodes);
        return acc;
    }

    private void expandAttr(RestOperation acc, RestOperation elem, Function<RestOperation, Map<String, ParameterDescription>> func) {
        Map<String, ParameterDescription> accMap = func.apply(acc);
        func.apply(elem).forEach(accMap::putIfAbsent);
    }

    public static String normalizePath(String path) {
        return path.replaceAll("\\{[^}]+\\}", "\\{\\}").replaceAll("/?$", "");
    }
}

