---

title: "Delete Tenant"
weight: 70

menu:
  main:
    name: "Delete"
    identifier: "rest-api-tenant-delete"
    parent: "rest-api-tenant"
    pre: "DELETE `/tenant/{id}`"

---


Deletes a tenant by id.


# Method

DELETE `/tenant/{id}`


# Parameters

## Path Parameters

<table class="table table-striped">
  <tr>
    <th>Name</th>
    <th>Description</th>
  </tr>
  <tr>
    <td>id</td>
    <td>The id of the tenant to be deleted.</td>
  </tr>
</table>


# Result

This method returns no content.


# Response Codes

<table class="table table-striped">
  <tr>
    <th>Code</th>
    <th>Media type</th>
    <th>Description</th>
  </tr>
  <tr>
    <td>200</td>
    <td>application/json</td>
    <td>Request successful.</td>
  </tr>
  <tr>
    <td>403</td>
    <td>application/json</td>
    <td>Identity service is read-only.</td>
  </tr>
  <tr>
    <td>404</td>
    <td>application/json</td>
    <td>Tenant cannot be found. See the <a href="{{< relref "reference/rest/overview/index.md#error-handling" >}}">Introduction</a> for the error response format.</td>
  </tr>
</table>


# Example

## Request

DELETE `/tenant/tenantOne`

## Response

Status 204. No content.
