/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate-swagger-json", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateSwaggerJsonMojo
extends AbstractMojo {
    public static final String GOAL = "generate-swagger-json";
    private static final String[] CORE_API = new String[]{"org.camunda.bpm.engine.rest.AuthorizationRestService", "org.camunda.bpm.engine.rest.BatchRestService", "org.camunda.bpm.engine.rest.CaseDefinitionRestService", "org.camunda.bpm.engine.rest.CaseExecutionRestService", "org.camunda.bpm.engine.rest.DecisionDefinitionRestService", "org.camunda.bpm.engine.rest.DecisionRequirementDefinitionRestService", "org.camunda.bpm.engine.rest.DeploymentRestService", "org.camunda.bpm.engine.rest.ExecutionRestService", "org.camunda.bpm.engine.rest.ExternalTaskRestService", "org.camunda.bpm.engine.rest.FilterRestService", "org.camunda.bpm.engine.rest.GroupRestService", "org.camunda.bpm.engine.rest.IdentityRestService", "org.camunda.bpm.engine.rest.JobDefinitionRestService", "org.camunda.bpm.engine.rest.JobRestService", "org.camunda.bpm.engine.rest.MessageRestService", "org.camunda.bpm.engine.rest.MigrationRestService", "org.camunda.bpm.engine.rest.ModificationRestService", "org.camunda.bpm.engine.rest.ProcessDefinitionRestService", "org.camunda.bpm.engine.rest.ProcessInstanceRestService", "org.camunda.bpm.engine.rest.TaskRestService", "org.camunda.bpm.engine.rest.TenantRestService", "org.camunda.bpm.engine.rest.UserRestService", "org.camunda.bpm.engine.rest.VariableInstanceRestService"};
    @Parameter(property="camunda.version", required=true)
    protected String camundaVersion;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="swaggerDirectory", required=true, defaultValue="${project.build.outputDirectory}/META-INF/resources")
    protected String swaggerDirectory;
    @Parameter(property="basePath", required=true, defaultValue="/engine-rest/engine/default")
    protected String basePath;
    @Parameter(property="host", required=true, defaultValue="localhost:8080")
    protected String host;
    @Component
    protected BuildPluginManager buildPluginManager;
    private static final Plugin SWAGGER_PLUGIN = MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.github.kongchen"), (String)MojoExecutor.artifactId((String)"swagger-maven-plugin"), (String)MojoExecutor.version((String)"3.1.5"), Collections.emptyList());

    public void execute() throws MojoExecutionException, MojoFailureException {
        MojoExecutor.ExecutionEnvironment environment = MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.buildPluginManager);
        MojoExecutor.executeMojo((Plugin)SWAGGER_PLUGIN, (String)"generate", (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"apiSources", (MojoExecutor.Element[])new MojoExecutor.Element[]{this.apiSource(CORE_API)})}), (MojoExecutor.ExecutionEnvironment)environment);
        this.getLog().info((CharSequence)String.format("generated swagger.json in '%s'", this.swaggerDirectory));
    }

    MojoExecutor.Element apiSource(String ... locations) {
        ArrayList coreLocations = new ArrayList();
        Arrays.stream(locations).forEach(location -> coreLocations.add(MojoExecutor.element((String)"location", (String)location)));
        return MojoExecutor.element((String)"apiSource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"swaggerDirectory", (String)this.swaggerDirectory), MojoExecutor.element((String)"attachSwaggerArtifact", (String)"true"), MojoExecutor.element((String)"springmvc", (String)"false"), MojoExecutor.element((String)"schemes", (String)"http"), MojoExecutor.element((String)"host", (String)this.host), MojoExecutor.element((String)"basePath", (String)this.basePath), MojoExecutor.element((String)"info", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"title", (String)"Camunda REST API"), MojoExecutor.element((String)"description", (String)"Swagger OpenApi Spec for Camunda REST API."), MojoExecutor.element((String)"version", (String)("v" + this.camundaVersion)), MojoExecutor.element((String)"license", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"url", (String)"http://www.apache.org/licenses/LICENSE-2.0.html"), MojoExecutor.element((String)"name", (String)"Apache 2.0")})}), MojoExecutor.element((String)"locations", (MojoExecutor.Element[])coreLocations.toArray(new MojoExecutor.Element[coreLocations.size()]))});
    }
}

