/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.camunda.bpm.swagger.docs.DocumentationYaml;
import org.camunda.bpm.swagger.docs.model.DtoDocs;
import org.camunda.bpm.swagger.docs.model.ServiceDocs;
import org.camunda.bpm.swagger.maven.fn.ReflectionsFactory;
import org.camunda.bpm.swagger.maven.fn.ScanRestServices;
import org.camunda.bpm.swagger.maven.generator.SwaggerServiceModelGenerator;
import org.camunda.bpm.swagger.maven.model.CamundaRestService;
import org.camunda.bpm.swagger.maven.model.ModelRepository;
import org.camunda.bpm.swagger.maven.spi.CodeGenerator;
import org.reflections.Reflections;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="generate-swagger-services", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=false)
public class GenerateSwaggerServicesMojo
extends AbstractMojo {
    public DocumentationYaml documentation;
    public static final String CAMUNDA_REST_ROOT_PKG = "org.camunda.bpm.engine.rest";
    public static final String GOAL = "generate-swagger-services";
    private ModelRepository modelRepository;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="outputDirectory", required=true, defaultValue="${project.build.directory}/generated-sources/java")
    protected File outputDirectory;
    @Parameter(property="codeGeneratorFactory", required=true, defaultValue="org.camunda.bpm.swagger.maven.generator.SwaggerCodeGeneratorFactory")
    protected String codeGeneratorFactoryClass;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camunda-rest-dto-docs.yaml", required=true, readonly=true)
    protected File dtoYamlFile;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camunda-rest-service-docs.yaml", required=true, readonly=true)
    protected File serviceYamlFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileWriter writer;
        Yaml yaml;
        this.documentation = new DocumentationYaml();
        this.modelRepository = new ModelRepository(this.documentation);
        if (!this.outputDirectory.exists()) {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        Optional.ofNullable(this.project).ifPresent(p -> p.addCompileSourceRoot(this.outputDirectory.getPath()));
        Reflections reflections = new ReflectionsFactory().get();
        ScanRestServices scanRestServices = new ScanRestServices(reflections, this.modelRepository);
        Object camundaRestServices = scanRestServices.get();
        camundaRestServices.stream().map(service -> new SwaggerServiceModelGenerator((CamundaRestService)service)).forEach(CodeGenerator::generate);
        if (this.modelRepository.getDtoParameterDescriptions().isEmpty()) {
            throw new IllegalStateException("No DTO docs has been provided.");
        }
        if (this.modelRepository.getRestServiceDescriptions().isEmpty()) {
            throw new IllegalStateException("No Service docs has been provided.");
        }
        if (this.dtoYamlFile != null) {
            yaml = new Yaml();
            writer = new FileWriter(this.dtoYamlFile);
            yaml.dump((Object)new DtoDocs(this.modelRepository.getDtoParameterDescriptions()), (Writer)writer);
        }
        if (this.serviceYamlFile != null) {
            yaml = new Yaml();
            writer = new FileWriter(this.serviceYamlFile);
            yaml.dump((Object)new ServiceDocs(this.modelRepository.getRestServiceDescriptions()), (Writer)writer);
        }
    }
}

