/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JCodeModel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.maven.generator.TypeHelper;
import org.camunda.bpm.swagger.maven.generator.step.TypeStep;
import org.camunda.bpm.swagger.maven.model.DocStyle;
import org.camunda.bpm.swagger.maven.model.ModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnTypeInfo {
    private static final Logger log = LoggerFactory.getLogger(ReturnTypeInfo.class);
    private final Method method;
    private Class<?> rawType;
    private AbstractJClass[] parameterTypes;
    private final List<TypeStep> dtos = new ArrayList<TypeStep>();
    private final ModelRepository modelRepository;
    private final JCodeModel codeModel;

    public ReturnTypeInfo(ModelRepository modelRepository, JCodeModel codeModel, Method method) {
        this.codeModel = codeModel;
        this.method = method;
        this.modelRepository = modelRepository;
        this.extractReturnType(this.method);
    }

    void extractReturnType(Method method) {
        Class result;
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            result = (Class)type.getRawType();
            AbstractJClass[] parameterClasses = new AbstractJClass[type.getActualTypeArguments().length];
            for (int i = 0; i < type.getActualTypeArguments().length; ++i) {
                Type typeArg = type.getActualTypeArguments()[i];
                if (typeArg instanceof Class) {
                    Class candidateParameterClass = (Class)typeArg;
                    if (TypeHelper.isDto(candidateParameterClass)) {
                        TypeStep dto = new TypeStep(this.modelRepository, candidateParameterClass, this.codeModel);
                        this.dtos.add(dto);
                        parameterClasses[i] = (AbstractJClass)dto.getType();
                        continue;
                    }
                    parameterClasses[i] = this.codeModel.ref(candidateParameterClass);
                    continue;
                }
                if (!(typeArg instanceof ParameterizedType)) continue;
                log.debug("The return type was a class parametrized by a parametrized class. The generator doesn't support it yet. Falling back to the basic type for {}", (Object)method);
                parameterClasses = new AbstractJClass[]{};
                break;
            }
            this.parameterTypes = parameterClasses;
        } else {
            result = method.getReturnType();
        }
        this.rawType = result;
    }

    public void documentationFound(RestOperation restOperation) {
        for (TypeStep dto : this.dtos) {
            this.modelRepository.addDoc(dto.getFullQualifiedName(), restOperation, DocStyle.TYPE_PARAM);
        }
    }

    public ReturnTypeInfo applyImplementationMethods(Method[] implementationMethods) {
        MethodMatcher matcher = new MethodMatcher(this.method);
        Arrays.stream(implementationMethods).filter(matcher).findFirst().ifPresent(matchedMethod -> {
            this.extractReturnType((Method)matchedMethod);
            log.warn("The implementing type returned a subclass of defined return type. This is not an error and the generator replaced return type in '{}' to '{}'", (Object)this.method, this.rawType);
        });
        return this;
    }

    public boolean isParametrized() {
        return this.parameterTypes != null && this.parameterTypes.length > 0;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public AbstractJClass[] getParameterTypes() {
        return this.parameterTypes;
    }

    static class MethodMatcher
    implements Predicate<Method> {
        private final Method original;

        public MethodMatcher(Method original) {
            this.original = original;
        }

        @Override
        public boolean test(Method candidate) {
            boolean result;
            boolean bl = result = this.original.getName().equals(candidate.getName()) && this.original.getParameterCount() == candidate.getParameterCount() && !this.original.getReturnType().equals(candidate.getReturnType());
            if (!result) {
                return false;
            }
            for (int i = 0; i < this.original.getParameterCount(); ++i) {
                if (this.original.getParameterTypes()[i].equals(candidate.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }
    }
}

