/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator;

import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import io.swagger.annotations.Api;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Path;
import org.apache.commons.lang3.tuple.Pair;
import org.camunda.bpm.swagger.docs.model.RestService;
import org.camunda.bpm.swagger.maven.generator.ParentInvocation;
import org.camunda.bpm.swagger.maven.generator.ResourceMethodGenerationHelper;
import org.camunda.bpm.swagger.maven.generator.ReturnTypeInfo;
import org.camunda.bpm.swagger.maven.generator.TagRespository;
import org.camunda.bpm.swagger.maven.generator.TypeHelper;
import org.camunda.bpm.swagger.maven.generator.step.InvocationStep;
import org.camunda.bpm.swagger.maven.generator.step.MethodStep;
import org.camunda.bpm.swagger.maven.model.CamundaRestService;
import org.camunda.bpm.swagger.maven.spi.CodeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerServiceModelGenerator
implements CodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(SwaggerServiceModelGenerator.class);
    private static final String NO_PREFIX = "";
    private final CamundaRestService camundaRestService;
    private final JCodeModel codeModel;

    public SwaggerServiceModelGenerator(CamundaRestService camundaRestService) {
        this.camundaRestService = camundaRestService;
        this.codeModel = camundaRestService.getCodeModel();
        log.debug("Processing REST service: {}", (Object)camundaRestService.getFullQualifiedName());
    }

    @Override
    public JCodeModel generate() {
        JDefinedClass c = this.camundaRestService.getDefinedClass();
        c._extends(this.camundaRestService.getServiceImplClass());
        c.annotate(this.codeModel.ref(Path.class)).param("value", this.camundaRestService.getPath());
        String tags = TagRespository.lookup(this.camundaRestService);
        this.camundaRestService.getRestService().setPath(this.camundaRestService.getPath());
        this.camundaRestService.getRestService().setTags(tags);
        this.camundaRestService.getRestService().setDescription(this.camundaRestService.getName());
        c.annotate(this.codeModel.ref(Api.class)).param("value", this.camundaRestService.getName()).param("tags", tags);
        for (Constructor<?> constructor : this.camundaRestService.getServiceImplClass().getConstructors()) {
            new InvocationStep(c.constructor(constructor.getModifiers())).constructor(constructor);
        }
        Map<Method, ReturnTypeInfo> returnTypes = Arrays.stream(this.camundaRestService.getServiceInterfaceClass().getDeclaredMethods()).map(m -> new ReturnTypeInfo(this.camundaRestService.getModelRepository(), this.codeModel, (Method)m).applyImplementationMethods(this.camundaRestService.getServiceImplClass().getDeclaredMethods())).collect(Collectors.toMap(r -> r.getMethod(), r -> r));
        this.generateMethods(c, this.camundaRestService.getRestService(), returnTypes, NO_PREFIX, new ParentInvocation[0]);
        return this.codeModel;
    }

    private void generateMethods(JDefinedClass clazz, RestService restService, Map<Method, ReturnTypeInfo> methods, String parentPathPrefix, ParentInvocation ... parentInvocations) {
        for (Method m : methods.keySet()) {
            MethodStep methodStep = new MethodStep(this.camundaRestService.getModelRepository(), restService, clazz);
            methodStep.create(methods.get(m), (Pair<String, String>)Pair.of((Object)this.camundaRestService.getPath(), (Object)parentPathPrefix), this.camundaRestService.getModelRepository().getDocumentation().get(), parentInvocations);
            if (!TypeHelper.isResource(methodStep.getReturnType())) continue;
            RestService resourceService = new RestService();
            resourceService.setTags(TagRespository.lookup(this.camundaRestService));
            this.camundaRestService.getModelRepository().addService(methodStep.getReturnType().getName(), resourceService);
            this.generateMethods(clazz, resourceService, ResourceMethodGenerationHelper.resourceReturnTypeInfos(this.camundaRestService.getModelRepository(), this.codeModel, methodStep.getReturnType()), methodStep.getPath(), ResourceMethodGenerationHelper.createParentInvocations(parentInvocations, m));
        }
    }
}

