/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.CaseExecutionRestService;
import org.camunda.bpm.engine.rest.CaseInstanceRestService;
import org.camunda.bpm.engine.rest.DecisionDefinitionRestService;
import org.camunda.bpm.engine.rest.DecisionRequirementsDefinitionRestService;
import org.camunda.bpm.engine.rest.JobDefinitionRestService;
import org.camunda.bpm.engine.rest.JobRestService;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.ProcessInstanceRestService;
import org.camunda.bpm.swagger.maven.generator.StringHelper;
import org.camunda.bpm.swagger.maven.model.CamundaRestService;

public class TagRespository {
    private static Map<Class<?>, String> tags = new HashMap();

    public static String lookup(CamundaRestService camundaRestService) {
        return tags.getOrDefault(camundaRestService.getServiceInterfaceClass(), TagRespository.getTag(camundaRestService));
    }

    public static String getTag(CamundaRestService camundaRestService) {
        return StringHelper.splitCamelCase(camundaRestService.getSimpleName()).split(" ")[0];
    }

    static {
        tags.put(CaseDefinitionRestService.class, "Case Definition");
        tags.put(CaseExecutionRestService.class, "Case Execution");
        tags.put(CaseInstanceRestService.class, "Case Instance");
        tags.put(DecisionDefinitionRestService.class, "Decision Definition");
        tags.put(DecisionRequirementsDefinitionRestService.class, "Decision Requirement Definition Execution");
        tags.put(JobDefinitionRestService.class, "Job Definition");
        tags.put(JobRestService.class, "Job Execution");
        tags.put(ProcessDefinitionRestService.class, "Process Definition");
        tags.put(ProcessInstanceRestService.class, "Process Instance");
    }
}

