/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator.step;

import com.helger.jcodemodel.JMethod;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ExternalDocs;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.apache.commons.lang3.text.WordUtils;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.maven.generator.StringHelper;
import org.camunda.bpm.swagger.maven.generator.TypeHelper;
import org.camunda.bpm.swagger.maven.generator.step.AbstractMethodStep;
import org.camunda.bpm.swagger.maven.generator.step.MethodStep;

public class ApiOperationStep
extends AbstractMethodStep {
    private final RestOperation restOperation;

    public ApiOperationStep(JMethod method, RestOperation restOperation) {
        super(method);
        this.restOperation = restOperation;
    }

    public void annotate(MethodStep methodStep, Method m) {
        if (!TypeHelper.isResource(methodStep.getReturnType())) {
            String description = this.restOperation != null && this.restOperation.getDescription() != null ? this.restOperation.getDescription() : WordUtils.capitalize((String)StringHelper.splitCamelCase(m.getName()));
            this.getMethod().annotate(ApiOperation.class).param("value", StringHelper.firstSentence(description)).param("notes", description);
            if (this.restOperation != null && this.restOperation.getExternalDocUrl() != null) {
                this.getMethod().annotate(ExternalDocs.class).param("value", "Reference Guide").param("url", this.restOperation.getExternalDocUrl());
            }
        }
    }

    static Class<?> findReturnTypeOfResource(Class<?> resource) {
        Optional<Method> defaultGet = Arrays.stream(resource.getMethods()).filter(m -> m.isAnnotationPresent(GET.class)).filter(m -> !m.isAnnotationPresent(Path.class) || m.isAnnotationPresent(Path.class) && m.getAnnotation(Path.class).value().equals("")).findFirst();
        if (defaultGet.isPresent()) {
            return defaultGet.get().getReturnType();
        }
        return resource;
    }
}

