/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator.step;

import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JMethod;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.Method;
import java.util.Map;
import org.camunda.bpm.swagger.docs.model.ParameterDescription;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.maven.generator.TypeHelper;
import org.camunda.bpm.swagger.maven.generator.step.AbstractMethodStep;
import org.camunda.bpm.swagger.maven.generator.step.MethodStep;

public class ApiResponsesStep
extends AbstractMethodStep {
    private final RestOperation restOperation;

    public ApiResponsesStep(JMethod method, RestOperation restOperation) {
        super(method);
        this.restOperation = restOperation;
    }

    public void annotate(MethodStep methodStep, Method m) {
        Map responseCodes;
        if (!TypeHelper.isResource(methodStep.getReturnType()) && this.restOperation != null && !(responseCodes = this.restOperation.getResponseCodes()).isEmpty()) {
            JAnnotationArrayMember responseArray = this.getMethod().annotate(ApiResponses.class).paramArray("value");
            for (String code : responseCodes.keySet()) {
                responseArray.annotate(ApiResponse.class).param("code", Integer.valueOf(code).intValue()).param("message", ((ParameterDescription)responseCodes.get(code)).getDescription());
            }
        }
    }
}

