/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator.step;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.camunda.bpm.swagger.docs.model.ParameterDescription;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.maven.generator.ParameterRepository;
import org.camunda.bpm.swagger.maven.generator.ParentInvocation;
import org.camunda.bpm.swagger.maven.generator.StringHelper;
import org.camunda.bpm.swagger.maven.generator.step.AbstractMethodStep;
import org.camunda.bpm.swagger.maven.generator.step.TypeStep;
import org.camunda.bpm.swagger.maven.model.DocStyle;
import org.camunda.bpm.swagger.maven.model.ModelRepository;
import org.springframework.beans.BeanUtils;

public class InvocationStep
extends AbstractMethodStep {
    public InvocationStep(JMethod method) {
        super(method);
    }

    public void dtoConstructor(Class<?> baseClass, String varName) {
        JBlock body = this.getMethod().body();
        body.invoke("super");
        JInvocation copyProperties = this.getMethod().owner().ref(BeanUtils.class).staticInvoke("copyProperties").arg((IJExpression)JExpr.ref((String)varName)).arg((IJExpression)JExpr.ref((String)"this"));
        body.add((IJStatement)copyProperties);
    }

    public JInvocation constructor(Constructor<?> constructor) {
        JInvocation superInvocation = this.getMethod().body().invoke("super");
        for (Parameter p : constructor.getParameters()) {
            Pair<Class<?>, String> pair = InvocationStep.parameter(p, constructor.getParameters());
            JVar param = this.getMethod().param((Class)pair.getLeft(), (String)pair.getRight());
            superInvocation.arg((IJExpression)param);
        }
        return superInvocation;
    }

    public JInvocation method(ModelRepository modelRepository, Method m, RestOperation doc, ParentInvocation ... parentInvocations) {
        JInvocation invoke = null;
        if (parentInvocations.length == 0) {
            invoke = JExpr._super().invoke(m.getName());
            for (Parameter p : m.getParameters()) {
                JVar jvar = InvocationStep.addMethodParameter(modelRepository, this.getMethod(), doc, p, m.getParameters());
                invoke.arg((IJExpression)jvar);
            }
        } else {
            for (ParentInvocation parentInvocation : parentInvocations) {
                invoke = invoke == null ? JExpr.invoke((String)parentInvocation.getMethodName()) : invoke.invoke(parentInvocation.getMethodName());
                for (Parameter p : parentInvocation.getParameters()) {
                    JVar jvar = InvocationStep.addMethodParameter(modelRepository, this.getMethod(), doc, p, m.getParameters());
                    invoke.arg((IJExpression)jvar);
                }
            }
            if (invoke == null) {
                throw new IllegalArgumentException("Invocation was empty.");
            }
            invoke = invoke.invoke(m.getName());
            for (Parameter p : m.getParameters()) {
                if (InvocationStep.parameterIsUnique(parentInvocations, p, m.getParameters())) {
                    JVar jvar = InvocationStep.addMethodParameter(modelRepository, this.getMethod(), doc, p, m.getParameters());
                    invoke.arg((IJExpression)jvar);
                    continue;
                }
                invoke.arg((IJExpression)JExpr.ref((String)InvocationStep.paramName(p, m.getParameters())));
            }
        }
        return invoke;
    }

    public static JVar addMethodParameter(ModelRepository modelRepository, JMethod method, RestOperation doc, Parameter p, Parameter[] all) {
        JVar jvar;
        Optional<Pair<Class<? extends Annotation>, String>> parameterAnnotationValue = InvocationStep.parameterAnnotation(p);
        String apiDocsParamName = null;
        Pair<Class<?>, String> pair = InvocationStep.parameter(p, all);
        TypeStep dtoStep = new TypeStep(modelRepository, (Class)pair.getLeft(), method.owner());
        AbstractJType type = dtoStep.getType();
        if (parameterAnnotationValue.isPresent()) {
            Pair<Class<? extends Annotation>, String> parameterAnnotation = parameterAnnotationValue.get();
            jvar = method.param(type, (String)parameterAnnotation.getRight());
            jvar.annotate((Class)parameterAnnotation.getLeft()).param("value", (String)parameterAnnotation.getRight());
            if (doc != null) {
                ParameterDescription parameterDescription = null;
                if (((Class)parameterAnnotation.getLeft()).isAssignableFrom(QueryParam.class)) {
                    parameterDescription = (ParameterDescription)doc.getQueryParameters().get(parameterAnnotation.getRight());
                } else if (((Class)parameterAnnotation.getLeft()).isAssignableFrom(PathParam.class)) {
                    parameterDescription = (ParameterDescription)doc.getPathParameters().get(parameterAnnotation.getRight());
                } else {
                    throw new IllegalArgumentException("Unknown parameter annotation of type " + ((Class)parameterAnnotation.getLeft()).getName());
                }
                if (parameterDescription != null) {
                    apiDocsParamName = parameterDescription.getDescription();
                }
            }
        } else {
            jvar = method.param(type, (String)pair.getRight());
        }
        if (!ParameterRepository.isPresent(type.fullName())) {
            JAnnotationUse apiParam = jvar.annotate(ApiParam.class).param("value", apiDocsParamName == null ? "Parameter " + jvar.name() : apiDocsParamName);
            if (dtoStep.isDto()) {
                apiParam.param("type", type.fullName());
                modelRepository.addDoc(dtoStep.getFullQualifiedName(), doc, DocStyle.METHOD_PARAM);
            }
        } else if (ParameterRepository.generateIimplicitParams(type.fullName()) && doc != null) {
            JAnnotationArrayMember implicitParamsAnnotation = method.annotate(ApiImplicitParams.class).paramArray("value");
            for (String paramName : doc.getQueryParameters().keySet()) {
                ParameterDescription parameterDescription = (ParameterDescription)doc.getQueryParameters().get(paramName);
                implicitParamsAnnotation.annotate(ApiImplicitParam.class).param("name", paramName).param("value", parameterDescription.getDescription() == null ? "Parameter" + paramName : parameterDescription.getDescription()).param("dataType", parameterDescription.getType() == null ? "string" : parameterDescription.getType()).param("paramType", "query").param("required", parameterDescription.getRequired() == null ? false : parameterDescription.getRequired());
            }
        }
        return jvar;
    }

    public static Optional<Pair<Class<? extends Annotation>, String>> parameterAnnotation(AnnotatedElement element) {
        PathParam pathParam = element.getAnnotation(PathParam.class);
        if (pathParam != null) {
            return Optional.of(Pair.of(PathParam.class, (Object)StringHelper.camelize(pathParam.value())));
        }
        QueryParam queryParam = element.getAnnotation(QueryParam.class);
        if (queryParam != null) {
            return Optional.of(Pair.of(QueryParam.class, (Object)StringHelper.camelize(queryParam.value())));
        }
        return Optional.empty();
    }

    public static Pair<Class<?>, String> parameter(Parameter param, Parameter[] all) {
        Optional<Pair<Class<?>, String>> lookup = ParameterRepository.lookup(param);
        return lookup.orElse(Pair.of(param.getType(), (Object)InvocationStep.paramName(param, all)));
    }

    public static String paramName(Parameter param, Parameter[] all) {
        String paramName;
        Optional<Pair<Class<? extends Annotation>, String>> parameterAnnotation = InvocationStep.parameterAnnotation(param);
        if (parameterAnnotation.isPresent()) {
            paramName = (String)parameterAnnotation.get().getValue();
        } else {
            paramName = param.getType().isPrimitive() ? param.getType().getSimpleName() + "Arg" : param.getType().getSimpleName();
            int found = 0;
            for (Parameter p : all) {
                if (InvocationStep.parameterAnnotation(param).isPresent() || !p.getType().equals(param.getType())) continue;
                ++found;
            }
            if (found > 1) {
                paramName = paramName + ThreadLocalRandom.current().nextInt(0, 9999);
            }
        }
        return WordUtils.uncapitalize((String)paramName);
    }

    public static boolean parameterIsUnique(ParentInvocation[] parentInvocations, Parameter param, Parameter[] all) {
        String paramName = InvocationStep.paramName(param, all);
        for (ParentInvocation pi : parentInvocations) {
            for (Parameter p : pi.getParameters()) {
                if (!InvocationStep.paramName(p, all).equals(paramName)) continue;
                return false;
            }
        }
        return true;
    }
}

