/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator.step;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.camunda.bpm.swagger.docs.DocumentationYaml;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.docs.model.RestService;
import org.camunda.bpm.swagger.maven.generator.ParentInvocation;
import org.camunda.bpm.swagger.maven.generator.ReturnTypeInfo;
import org.camunda.bpm.swagger.maven.generator.StringHelper;
import org.camunda.bpm.swagger.maven.generator.TypeHelper;
import org.camunda.bpm.swagger.maven.generator.step.ApiOperationStep;
import org.camunda.bpm.swagger.maven.generator.step.ApiResponsesStep;
import org.camunda.bpm.swagger.maven.generator.step.ConsumesAndProducesStep;
import org.camunda.bpm.swagger.maven.generator.step.InvocationStep;
import org.camunda.bpm.swagger.maven.generator.step.JaxRsAnnotationStep;
import org.camunda.bpm.swagger.maven.generator.step.PathAnnotationStep;
import org.camunda.bpm.swagger.maven.generator.step.TypeStep;
import org.camunda.bpm.swagger.maven.model.DocStyle;
import org.camunda.bpm.swagger.maven.model.ModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodStep {
    private static final Logger log = LoggerFactory.getLogger(MethodStep.class);
    private final ModelRepository modelRepository;
    private final RestService restService;
    private final JDefinedClass clazz;
    private JMethod method;
    private Class<?> returnType;
    private ReturnTypeStyle returnTypeStyle;
    private AbstractJType methodReturnType;
    private String path;

    public MethodStep(ModelRepository modelRepository, RestService restService, JDefinedClass clazz) {
        this.modelRepository = modelRepository;
        this.restService = restService;
        this.clazz = clazz;
    }

    public JMethod create(ReturnTypeInfo info, Pair<String, String> pathPrefix, Map<Pair<String, String>, RestOperation> docs, ParentInvocation ... parentInvocations) {
        this.returnType = info.getRawType();
        Optional<Object> dto = Optional.empty();
        if (info.isParametrized()) {
            this.methodReturnType = this.clazz.owner().ref(info.getRawType()).narrow(info.getParameterTypes());
            if (TypeHelper.isList(info.getRawType())) {
                this.returnTypeStyle = ReturnTypeStyle.DTO_LIST;
            } else if (TypeHelper.isMap(info.getRawType()) && info.getParameterTypes().length == 2 && TypeHelper.isString((AbstractJType)info.getParameterTypes()[0])) {
                this.returnTypeStyle = ReturnTypeStyle.DTO_MAP_STRING;
            } else {
                log.debug("Unsupported return collection type with {} type parameters:", (Object)info.getParameterTypes().length, (Object)info.getRawType().getName());
                this.returnTypeStyle = ReturnTypeStyle.PLAIN;
            }
        } else {
            dto = Optional.of(new TypeStep(this.modelRepository, info.getRawType(), this.clazz.owner()));
            this.returnTypeStyle = ((TypeStep)dto.get()).isDto() ? ReturnTypeStyle.DTO : ReturnTypeStyle.PLAIN;
            this.methodReturnType = ((TypeStep)dto.get()).getType();
        }
        String methodName = MethodStep.methodName(parentInvocations, info.getMethod().getName());
        this.method = this.clazz.method(1, this.methodReturnType, methodName);
        PathAnnotationStep pathAnnotationStep = new PathAnnotationStep(this);
        pathAnnotationStep.annotate((String)pathPrefix.getRight(), info.getMethod());
        this.path = pathAnnotationStep.getPath();
        JaxRsAnnotationStep jaxrsAnnotation = new JaxRsAnnotationStep(this.method);
        jaxrsAnnotation.annotate(info.getMethod());
        ConsumesAndProducesStep consumesAndProduces = new ConsumesAndProducesStep(this.method);
        consumesAndProduces.annotate(info.getMethod());
        Pair key = Pair.of((Object)DocumentationYaml.normalizePath((String)((String)pathPrefix.getLeft() + this.path)), (Object)jaxrsAnnotation.getType().getSimpleName());
        RestOperation doc = docs.get(key);
        if (doc == null) {
            log.error("No doc found for {}", (Object)key);
        }
        if (dto.isPresent()) {
            this.modelRepository.addDoc(((TypeStep)dto.get()).getFullQualifiedName(), doc, DocStyle.RETURN_TYPE);
        }
        JInvocation invoke = new InvocationStep(this.method).method(this.modelRepository, info.getMethod(), doc, parentInvocations);
        if (TypeHelper.isVoid(this.getReturnType())) {
            this.method.body().add((IJStatement)invoke);
        } else {
            if (parentInvocations == null) {
                this.method.annotate(Override.class);
            }
            this.method.body()._return((IJExpression)invoke);
        }
        ApiOperationStep apiOperation = new ApiOperationStep(this.method, doc);
        apiOperation.annotate(this, info.getMethod());
        this.restService.getOperations().put(info.getMethod().getName(), doc);
        ApiResponsesStep responesStep = new ApiResponsesStep(this.method, doc);
        responesStep.annotate(this, info.getMethod());
        return this.method;
    }

    static String methodName(ParentInvocation[] parentInvocations, String name) {
        StringBuilder builder = new StringBuilder();
        for (ParentInvocation parentInvocation : parentInvocations) {
            builder.append(StringHelper.toFirstUpper(parentInvocation.getMethodName()));
        }
        builder.append(StringHelper.toFirstUpper(name));
        return StringHelper.toFirstLower(builder.toString());
    }

    public ModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public RestService getRestService() {
        return this.restService;
    }

    public JDefinedClass getClazz() {
        return this.clazz;
    }

    public JMethod getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public ReturnTypeStyle getReturnTypeStyle() {
        return this.returnTypeStyle;
    }

    public AbstractJType getMethodReturnType() {
        return this.methodReturnType;
    }

    public String getPath() {
        return this.path;
    }

    public void setMethod(JMethod method) {
        this.method = method;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public void setReturnTypeStyle(ReturnTypeStyle returnTypeStyle) {
        this.returnTypeStyle = returnTypeStyle;
    }

    public void setMethodReturnType(AbstractJType methodReturnType) {
        this.methodReturnType = methodReturnType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodStep)) {
            return false;
        }
        MethodStep other = (MethodStep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ModelRepository this$modelRepository = this.getModelRepository();
        ModelRepository other$modelRepository = other.getModelRepository();
        if (this$modelRepository == null ? other$modelRepository != null : !this$modelRepository.equals(other$modelRepository)) {
            return false;
        }
        RestService this$restService = this.getRestService();
        RestService other$restService = other.getRestService();
        if (this$restService == null ? other$restService != null : !this$restService.equals(other$restService)) {
            return false;
        }
        JDefinedClass this$clazz = this.getClazz();
        JDefinedClass other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        JMethod this$method = this.getMethod();
        JMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Class<?> this$returnType = this.getReturnType();
        Class<?> other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        ReturnTypeStyle this$returnTypeStyle = this.getReturnTypeStyle();
        ReturnTypeStyle other$returnTypeStyle = other.getReturnTypeStyle();
        if (this$returnTypeStyle == null ? other$returnTypeStyle != null : !((Object)((Object)this$returnTypeStyle)).equals((Object)other$returnTypeStyle)) {
            return false;
        }
        AbstractJType this$methodReturnType = this.getMethodReturnType();
        AbstractJType other$methodReturnType = other.getMethodReturnType();
        if (this$methodReturnType == null ? other$methodReturnType != null : !this$methodReturnType.equals(other$methodReturnType)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodStep;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModelRepository $modelRepository = this.getModelRepository();
        result = result * 59 + ($modelRepository == null ? 43 : $modelRepository.hashCode());
        RestService $restService = this.getRestService();
        result = result * 59 + ($restService == null ? 43 : $restService.hashCode());
        JDefinedClass $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        JMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Class<?> $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        ReturnTypeStyle $returnTypeStyle = this.getReturnTypeStyle();
        result = result * 59 + ($returnTypeStyle == null ? 43 : ((Object)((Object)$returnTypeStyle)).hashCode());
        AbstractJType $methodReturnType = this.getMethodReturnType();
        result = result * 59 + ($methodReturnType == null ? 43 : $methodReturnType.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "MethodStep(modelRepository=" + this.getModelRepository() + ", restService=" + this.getRestService() + ", clazz=" + this.getClazz() + ", method=" + this.getMethod() + ", returnType=" + this.getReturnType() + ", returnTypeStyle=" + (Object)((Object)this.getReturnTypeStyle()) + ", methodReturnType=" + this.getMethodReturnType() + ", path=" + this.getPath() + ")";
    }

    public static enum ReturnTypeStyle {
        PLAIN,
        DTO,
        DTO_LIST,
        DTO_MAP_STRING;

    }
}

