/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.generator.step;

import com.helger.jcodemodel.JMethod;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.ws.rs.Path;
import org.camunda.bpm.swagger.maven.generator.TypeHelper;
import org.camunda.bpm.swagger.maven.generator.step.AbstractMethodStep;
import org.camunda.bpm.swagger.maven.generator.step.MethodStep;

public class PathAnnotationStep
extends AbstractMethodStep {
    private final MethodStep methodStep;
    private String path;

    public PathAnnotationStep(MethodStep methodStep) {
        super(methodStep.getMethod());
        this.methodStep = methodStep;
    }

    public static String path(String parentPathPrefix, Method method) {
        String currentPath;
        StringBuilder pathBuilder;
        StringBuilder stringBuilder = pathBuilder = parentPathPrefix == null ? new StringBuilder("") : new StringBuilder(parentPathPrefix);
        if (pathBuilder.length() > 0 && pathBuilder.lastIndexOf("/") == pathBuilder.length() - 1) {
            pathBuilder.deleteCharAt(pathBuilder.length() - 1);
        }
        if (!(currentPath = Optional.ofNullable(method.getAnnotation(Path.class)).map(a -> a.value()).orElse("")).isEmpty() && !currentPath.startsWith("/")) {
            pathBuilder.append("/").append(currentPath);
        } else {
            pathBuilder.append(currentPath);
        }
        return pathBuilder.toString();
    }

    public JMethod annotate(String parentPathPrefix, Method method) {
        this.path = PathAnnotationStep.path(parentPathPrefix, method);
        if (!TypeHelper.isResource(this.methodStep.getReturnType())) {
            this.getMethod().annotate(Path.class).param("value", this.path);
        }
        return this.getMethod();
    }

    public MethodStep getMethodStep() {
        return this.methodStep;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String toString() {
        return "PathAnnotationStep(methodStep=" + this.getMethodStep() + ", path=" + this.getPath() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathAnnotationStep)) {
            return false;
        }
        PathAnnotationStep other = (PathAnnotationStep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodStep this$methodStep = this.getMethodStep();
        MethodStep other$methodStep = other.getMethodStep();
        if (this$methodStep == null ? other$methodStep != null : !((Object)this$methodStep).equals(other$methodStep)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PathAnnotationStep;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        MethodStep $methodStep = this.getMethodStep();
        result = result * 59 + ($methodStep == null ? 43 : ((Object)$methodStep).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

