/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.model;

import com.helger.jcodemodel.JCodeModel;
import java.io.File;
import org.camunda.bpm.swagger.maven.generator.StringHelper;
import org.camunda.bpm.swagger.maven.model.ModelRepository;

public abstract class AbstractModel {
    private final ModelRepository modelRepository;

    public AbstractModel(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        this.modelRepository.addModel(this);
    }

    public abstract JCodeModel getCodeModel();

    public abstract String getFullQualifiedName();

    public abstract String getSimpleName();

    public abstract Package getPackage();

    public abstract Class<?> getBaseClass();

    public void write(File destination) {
        if (!(destination != null && destination.canWrite() && destination.exists() && destination.isDirectory())) {
            throw new IllegalStateException("Cannot write to " + destination);
        }
        this.getCodeModel().build(destination);
    }

    public String getName() {
        String[] n = StringHelper.splitCamelCase(this.getSimpleName()).split(" ");
        return n[0] + " " + n[2];
    }

    public String getPackageName() {
        return this.getPackage().getName();
    }

    public ModelRepository getModelRepository() {
        return this.modelRepository;
    }
}

