/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.swagger.docs.DocumentationYaml;
import org.camunda.bpm.swagger.docs.model.ParameterDescription;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.docs.model.RestService;
import org.camunda.bpm.swagger.maven.model.AbstractModel;
import org.camunda.bpm.swagger.maven.model.DocStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRepository {
    private static final Logger log = LoggerFactory.getLogger(ModelRepository.class);
    private final Set<AbstractModel> models = new HashSet<AbstractModel>();
    private final Map<String, Map<String, ParameterDescription>> dtoParameterDescriptions = new HashMap<String, Map<String, ParameterDescription>>();
    private final Map<String, RestService> restServiceDescriptions = new HashMap<String, RestService>();
    private final DocumentationYaml documentation;

    public ModelRepository(DocumentationYaml documentationYml) {
        this.documentation = documentationYml;
    }

    public void addService(String fqn, RestService restService) {
        if (restService == null) {
            return;
        }
        if (this.restServiceDescriptions.containsKey(fqn)) {
            log.error("Duplicate REST service documentation for {}, merging values.", (Object)fqn);
            RestService savedRestService = this.restServiceDescriptions.get(fqn);
            savedRestService.getOperations().putAll(restService.getOperations());
            if (savedRestService.getTags() != null && restService.getTags() != null && !savedRestService.getTags().contains(restService.getTags())) {
                savedRestService.setTags(savedRestService.getTags() + "," + restService.getTags());
            }
        } else {
            this.restServiceDescriptions.put(fqn, restService);
        }
    }

    public void addDoc(String fqn, RestOperation restOperation, DocStyle style) {
        if (restOperation == null) {
            return;
        }
        Map<String, ParameterDescription> parameters = this.dtoParameterDescriptions.get(fqn);
        if (parameters == null) {
            parameters = new HashMap<String, ParameterDescription>();
            this.dtoParameterDescriptions.put(fqn, parameters);
        }
        Map fieldDescriptions = null;
        switch (style) {
            case RETURN_TYPE: {
                fieldDescriptions = restOperation.getResult();
                break;
            }
            case METHOD_PARAM: {
                fieldDescriptions = restOperation.getRequestBody();
                break;
            }
        }
        if (fieldDescriptions != null) {
            parameters.putAll(fieldDescriptions);
        }
    }

    @Deprecated
    public AbstractModel addModel(AbstractModel model) {
        if (this.models.contains(model)) {
            log.error("Duplicate model added to repository {}", (Object)model.getFullQualifiedName());
        }
        this.models.add(model);
        return model;
    }

    public Set<AbstractModel> getModels() {
        return this.models;
    }

    public Map<String, Map<String, ParameterDescription>> getDtoParameterDescriptions() {
        return this.dtoParameterDescriptions;
    }

    public Map<String, RestService> getRestServiceDescriptions() {
        return this.restServiceDescriptions;
    }

    public DocumentationYaml getDocumentation() {
        return this.documentation;
    }
}

