/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.spoon;

import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.camunda.bpm.swagger.docs.DtoDocsYaml;
import org.camunda.bpm.swagger.docs.ServiceDocsYaml;
import org.camunda.bpm.swagger.docs.model.DtoDocs;
import org.camunda.bpm.swagger.docs.model.ServiceDocs;
import org.camunda.bpm.swagger.maven.spoon.fn.DownloadCamundaSources;
import org.camunda.bpm.swagger.maven.spoon.processor.ApiModelProcessor;
import org.camunda.bpm.swagger.maven.spoon.processor.ApiModelPropertyProcessor;
import org.camunda.bpm.swagger.maven.spoon.processor.RestResourceMethodProcessor;
import org.camunda.bpm.swagger.maven.spoon.processor.RestResourceProcessor;
import org.camunda.bpm.swagger.maven.spoon.processor.RestServiceMethodProcessor;
import org.camunda.bpm.swagger.maven.spoon.processor.RestServiceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import spoon.Launcher;
import spoon.SpoonAPI;
import spoon.processing.Processor;

@Mojo(name="process", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SpoonProcessingMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(SpoonProcessingMojo.class);
    public static final String GOAL = "process";
    @Parameter(property="camunda.version", required=true)
    protected String camundaVersion;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="target/unpack")
    protected File unpackDirectory;
    @Parameter(defaultValue="target/generated-sources/java")
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camunda-rest-dto-docs.yaml", required=true, readonly=true)
    protected File dtoYamlFile;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camunda-rest-service-docs.yaml", required=true, readonly=true)
    protected File serviceYamlFile;
    @Component
    protected BuildPluginManager buildPluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Context.builder().executionEnvironment(MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.buildPluginManager)).camundaVersion(this.camundaVersion).unpackDirectory(this.unpackDirectory).outputDirectory(this.outputDirectory).noClasspath(false).autoImports(false).shouldCompile(false).dtoYamlFile(this.dtoYamlFile).serviceYamlFile(this.serviceYamlFile).build().initDirectory().downloadSources().loadDtoDocumentation().loadServiceDocumentation().processSources();
    }

    public static class Context {
        private final boolean shouldCompile;
        private final boolean autoImports;
        private final boolean noClasspath;
        @NonNull
        private final File unpackDirectory;
        @NonNull
        private final File outputDirectory;
        @NonNull
        private final String camundaVersion;
        @NonNull
        private final MojoExecutor.ExecutionEnvironment executionEnvironment;
        private final File dtoYamlFile;
        private final File serviceYamlFile;
        private DtoDocs dtoDocumentation;
        private ServiceDocs serviceDocumentation;

        public Context initDirectory() {
            if (!this.unpackDirectory.exists()) {
                Files.createDirectories(this.unpackDirectory.toPath(), new FileAttribute[0]);
            }
            return this;
        }

        private SpoonAPI spoon() {
            Launcher spoon = new Launcher();
            spoon.getEnvironment().setShouldCompile(this.shouldCompile);
            spoon.getEnvironment().setAutoImports(this.autoImports);
            spoon.getEnvironment().setNoClasspath(this.noClasspath);
            spoon.addProcessor((Processor)new ApiModelProcessor());
            spoon.addProcessor((Processor)new ApiModelPropertyProcessor(this));
            spoon.addProcessor((Processor)new RestResourceProcessor(this));
            spoon.addProcessor((Processor)new RestResourceMethodProcessor(this));
            spoon.addProcessor((Processor)new RestServiceProcessor(this));
            spoon.addProcessor((Processor)new RestServiceMethodProcessor(this));
            String[] classpathElements = (String[])this.executionEnvironment.getMavenProject().getCompileClasspathElements().stream().filter(s -> !this.executionEnvironment.getMavenProject().getBuild().getOutputDirectory().equals(s)).toArray(String[]::new);
            StringBuilder builder = new StringBuilder();
            Arrays.stream(classpathElements).forEach(builder::append);
            log.debug("Using classpath: {}", (Object)builder.toString());
            spoon.getEnvironment().setSourceClasspath(classpathElements);
            spoon.addInputResource(this.unpackDirectory.getPath());
            spoon.setSourceOutputDirectory(this.outputDirectory.getPath());
            return spoon;
        }

        public Context loadDtoDocumentation() {
            this.dtoDocumentation = new DtoDocsYaml().apply(this.dtoYamlFile);
            return this;
        }

        public Context loadServiceDocumentation() {
            this.serviceDocumentation = new ServiceDocsYaml().apply(this.serviceYamlFile);
            return this;
        }

        public Context downloadSources() {
            new DownloadCamundaSources(this).run();
            return this;
        }

        public Context processSources() {
            this.spoon().run();
            return this;
        }

        @ConstructorProperties(value={"shouldCompile", "autoImports", "noClasspath", "unpackDirectory", "outputDirectory", "camundaVersion", "executionEnvironment", "dtoYamlFile", "serviceYamlFile", "dtoDocumentation", "serviceDocumentation"})
        Context(boolean shouldCompile, boolean autoImports, boolean noClasspath, @NonNull File unpackDirectory, @NonNull File outputDirectory, @NonNull String camundaVersion, @NonNull MojoExecutor.ExecutionEnvironment executionEnvironment, File dtoYamlFile, File serviceYamlFile, DtoDocs dtoDocumentation, ServiceDocs serviceDocumentation) {
            if (unpackDirectory == null) {
                throw new NullPointerException("unpackDirectory");
            }
            if (outputDirectory == null) {
                throw new NullPointerException("outputDirectory");
            }
            if (camundaVersion == null) {
                throw new NullPointerException("camundaVersion");
            }
            if (executionEnvironment == null) {
                throw new NullPointerException("executionEnvironment");
            }
            this.shouldCompile = shouldCompile;
            this.autoImports = autoImports;
            this.noClasspath = noClasspath;
            this.unpackDirectory = unpackDirectory;
            this.outputDirectory = outputDirectory;
            this.camundaVersion = camundaVersion;
            this.executionEnvironment = executionEnvironment;
            this.dtoYamlFile = dtoYamlFile;
            this.serviceYamlFile = serviceYamlFile;
            this.dtoDocumentation = dtoDocumentation;
            this.serviceDocumentation = serviceDocumentation;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public boolean isShouldCompile() {
            return this.shouldCompile;
        }

        public boolean isAutoImports() {
            return this.autoImports;
        }

        public boolean isNoClasspath() {
            return this.noClasspath;
        }

        @NonNull
        public File getUnpackDirectory() {
            return this.unpackDirectory;
        }

        @NonNull
        public File getOutputDirectory() {
            return this.outputDirectory;
        }

        @NonNull
        public String getCamundaVersion() {
            return this.camundaVersion;
        }

        @NonNull
        public MojoExecutor.ExecutionEnvironment getExecutionEnvironment() {
            return this.executionEnvironment;
        }

        public File getDtoYamlFile() {
            return this.dtoYamlFile;
        }

        public File getServiceYamlFile() {
            return this.serviceYamlFile;
        }

        public DtoDocs getDtoDocumentation() {
            return this.dtoDocumentation;
        }

        public ServiceDocs getServiceDocumentation() {
            return this.serviceDocumentation;
        }

        public static class ContextBuilder {
            private boolean shouldCompile;
            private boolean autoImports;
            private boolean noClasspath;
            private File unpackDirectory;
            private File outputDirectory;
            private String camundaVersion;
            private MojoExecutor.ExecutionEnvironment executionEnvironment;
            private File dtoYamlFile;
            private File serviceYamlFile;
            private DtoDocs dtoDocumentation;
            private ServiceDocs serviceDocumentation;

            ContextBuilder() {
            }

            public ContextBuilder shouldCompile(boolean shouldCompile) {
                this.shouldCompile = shouldCompile;
                return this;
            }

            public ContextBuilder autoImports(boolean autoImports) {
                this.autoImports = autoImports;
                return this;
            }

            public ContextBuilder noClasspath(boolean noClasspath) {
                this.noClasspath = noClasspath;
                return this;
            }

            public ContextBuilder unpackDirectory(File unpackDirectory) {
                this.unpackDirectory = unpackDirectory;
                return this;
            }

            public ContextBuilder outputDirectory(File outputDirectory) {
                this.outputDirectory = outputDirectory;
                return this;
            }

            public ContextBuilder camundaVersion(String camundaVersion) {
                this.camundaVersion = camundaVersion;
                return this;
            }

            public ContextBuilder executionEnvironment(MojoExecutor.ExecutionEnvironment executionEnvironment) {
                this.executionEnvironment = executionEnvironment;
                return this;
            }

            public ContextBuilder dtoYamlFile(File dtoYamlFile) {
                this.dtoYamlFile = dtoYamlFile;
                return this;
            }

            public ContextBuilder serviceYamlFile(File serviceYamlFile) {
                this.serviceYamlFile = serviceYamlFile;
                return this;
            }

            public ContextBuilder dtoDocumentation(DtoDocs dtoDocumentation) {
                this.dtoDocumentation = dtoDocumentation;
                return this;
            }

            public ContextBuilder serviceDocumentation(ServiceDocs serviceDocumentation) {
                this.serviceDocumentation = serviceDocumentation;
                return this;
            }

            public Context build() {
                return new Context(this.shouldCompile, this.autoImports, this.noClasspath, this.unpackDirectory, this.outputDirectory, this.camundaVersion, this.executionEnvironment, this.dtoYamlFile, this.serviceYamlFile, this.dtoDocumentation, this.serviceDocumentation);
            }

            public String toString() {
                return "SpoonProcessingMojo.Context.ContextBuilder(shouldCompile=" + this.shouldCompile + ", autoImports=" + this.autoImports + ", noClasspath=" + this.noClasspath + ", unpackDirectory=" + this.unpackDirectory + ", outputDirectory=" + this.outputDirectory + ", camundaVersion=" + this.camundaVersion + ", executionEnvironment=" + this.executionEnvironment + ", dtoYamlFile=" + this.dtoYamlFile + ", serviceYamlFile=" + this.serviceYamlFile + ", dtoDocumentation=" + this.dtoDocumentation + ", serviceDocumentation=" + this.serviceDocumentation + ")";
            }
        }
    }
}

