/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.spoon.processor;

import io.swagger.annotations.ApiModel;
import org.camunda.bpm.swagger.maven.spoon.processor.ClassPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;

public class ApiModelProcessor
extends AbstractProcessor<CtClass<?>> {
    private static final Logger log = LoggerFactory.getLogger(ApiModelProcessor.class);

    public boolean isToBeProcessed(CtClass<?> candidate) {
        return ClassPredicates.isNamedDto.and(ClassPredicates.isNotAbstract).test(candidate);
    }

    public void process(CtClass<?> element) {
        CtAnnotation annotation = this.getFactory().Code().createAnnotation(this.getFactory().Code().createCtTypeReference(ApiModel.class));
        element.addAnnotation(annotation);
        log.debug("Add ApiModel to {}", (Object)element.getQualifiedName());
    }
}

