/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.spoon.processor;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.swagger.docs.model.ParameterDescription;
import org.camunda.bpm.swagger.maven.spoon.SpoonProcessingMojo;
import org.camunda.bpm.swagger.maven.spoon.processor.MethodPredicates;
import org.camunda.bpm.swagger.maven.spoon.processor.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtMethod;

public class ApiModelPropertyProcessor
extends AbstractProcessor<CtMethod<?>> {
    private static final Logger log = LoggerFactory.getLogger(ApiModelPropertyProcessor.class);
    private final SpoonProcessingMojo.Context context;

    public ApiModelPropertyProcessor(SpoonProcessingMojo.Context context) {
        this.context = context;
    }

    public boolean isToBeProcessed(CtMethod<?> candidate) {
        return MethodPredicates.classIsNamedDto.and(MethodPredicates.startsWithGet).and(MethodPredicates.isPublic).and(MethodPredicates.takesNoParameters).test(candidate);
    }

    public void process(CtMethod<?> method) {
        ParameterDescription parameterDescription;
        CtAnnotation annotation = this.getFactory().Code().createAnnotation(this.getFactory().Code().createCtTypeReference(ApiModelProperty.class));
        String fieldName = StringUtils.uncapitalize((String)StringUtils.removeStart((String)method.getSimpleName(), (String)"get"));
        String classFqn = TypeHelper.getClassname(method);
        Map docs = this.context.getDtoDocumentation().get(classFqn);
        if (docs != null && (parameterDescription = (ParameterDescription)docs.get(fieldName)) != null) {
            log.debug("Found parameter description for {} {}", (Object)classFqn, (Object)fieldName);
            annotation.addValue("value", (Object)parameterDescription.getDescription());
            if (parameterDescription.getRequired() != null) {
                annotation.addValue("required", (Object)parameterDescription.getRequired());
            }
        }
        annotation.addValue("name", (Object)fieldName);
        method.addAnnotation(annotation);
    }
}

