/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.spoon.processor;

import io.swagger.annotations.Api;
import org.camunda.bpm.swagger.docs.model.RestService;
import org.camunda.bpm.swagger.maven.spoon.SpoonProcessingMojo;
import org.camunda.bpm.swagger.maven.spoon.processor.ClassPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;

public class RestResourceProcessor
extends AbstractProcessor<CtInterface<?>> {
    private static final Logger log = LoggerFactory.getLogger(RestResourceProcessor.class);
    private final SpoonProcessingMojo.Context context;

    public RestResourceProcessor(SpoonProcessingMojo.Context context) {
        this.context = context;
    }

    public boolean isToBeProcessed(CtInterface<?> candidate) {
        return ClassPredicates.isNamedResource.test((CtType<?>)candidate);
    }

    public void process(CtInterface<?> resourceInterface) {
        CtAnnotation annotation = this.getFactory().Code().createAnnotation(this.getFactory().Code().createCtTypeReference(Api.class));
        RestService restService = this.context.getServiceDocumentation().get(resourceInterface.getQualifiedName());
        if (restService != null) {
            if (restService.getTags().contains(",")) {
                String[] tags = restService.getTags().split(",");
            } else {
                String[] tags = new String[]{restService.getTags()};
            }
            annotation.addValue("hidden", (Object)true);
            resourceInterface.addAnnotation(annotation);
        } else {
            log.error("No documentation for resource {} found.", (Object)resourceInterface.getQualifiedName());
        }
    }
}

