/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.spoon.processor;

import io.swagger.annotations.Api;
import javax.ws.rs.Path;
import org.camunda.bpm.swagger.docs.model.RestService;
import org.camunda.bpm.swagger.maven.spoon.SpoonProcessingMojo;
import org.camunda.bpm.swagger.maven.spoon.processor.ClassPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;

public class RestServiceProcessor
extends AbstractProcessor<CtInterface<?>> {
    private static final Logger log = LoggerFactory.getLogger(RestServiceProcessor.class);
    private final SpoonProcessingMojo.Context context;

    public RestServiceProcessor(SpoonProcessingMojo.Context context) {
        this.context = context;
    }

    public boolean isToBeProcessed(CtInterface<?> candidate) {
        return ClassPredicates.isNamedRestService.test((CtType<?>)candidate);
    }

    public void process(CtInterface<?> restServiceInterface) {
        CtAnnotation annotation = this.getFactory().Code().createAnnotation(this.getFactory().Code().createCtTypeReference(Api.class));
        String classFqn = restServiceInterface.getQualifiedName();
        RestService restService = this.context.getServiceDocumentation().get(classFqn);
        if (restService != null) {
            annotation.addValue("tags", (Object)restService.getTags());
            restServiceInterface.addAnnotation(annotation);
            Path pathAnnotation = (Path)restServiceInterface.getAnnotation(Path.class);
            if (pathAnnotation == null) {
                CtAnnotation path = this.getFactory().Code().createAnnotation(this.getFactory().Code().createCtTypeReference(Path.class));
                path.addValue("value", (Object)restService.getPath());
                restServiceInterface.addAnnotation(path);
            }
            log.debug("Added @Api to {} [{}]", (Object)restServiceInterface.getQualifiedName(), (Object)classFqn);
        } else {
            log.error("No documentation found for {} [{}]", (Object)restServiceInterface.getQualifiedName(), (Object)classFqn);
        }
    }
}

