/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.spoon.processor;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.reference.CtTypeReference;

public class TypeHelper {
    public static String getFirstInterfaceClassName(CtClass<?> impl) {
        if (impl == null) {
            return "";
        }
        return TypeHelper.getFirstSuperInterface(impl).map(CtTypeInformation::getQualifiedName).orElse("");
    }

    public static Optional<CtTypeReference<?>> getFirstSuperInterface(CtClass<?> impl) {
        return impl.getSuperInterfaces().stream().findFirst();
    }

    public static String getClassname(CtMethod<?> method) {
        return Optional.of(method).map(m -> (CtType)m.getParent(CtType.class)).map(CtTypeInformation::getQualifiedName).orElse("");
    }

    public static Class<? extends Annotation> javaxRsAnnotation(CtMethod<?> ctMethod) {
        for (Class a : Arrays.asList(POST.class, GET.class, PUT.class, DELETE.class, OPTIONS.class)) {
            if (ctMethod.getAnnotation(a) == null) continue;
            return a;
        }
        return null;
    }

    public static String path(CtMethod<?> ctMethod) {
        Optional<CtMethod<?>> interfaceMethod = TypeHelper.getInterfaceMethod(ctMethod);
        return interfaceMethod.map(m -> (Path)m.getAnnotation(Path.class)).map(a -> a.value()).orElse("/");
    }

    public static Optional<CtMethod<?>> getInterfaceMethod(CtMethod<?> ctMethod) {
        Optional<CtTypeReference<?>> firstSuperInterface;
        if (ctMethod.getDeclaringType() instanceof CtClass && (firstSuperInterface = TypeHelper.getFirstSuperInterface((CtClass)ctMethod.getDeclaringType())).isPresent()) {
            return firstSuperInterface.get().getDeclaration().getMethods().stream().filter(m -> m.getSignature().equals(ctMethod.getSignature())).findFirst();
        }
        return Optional.empty();
    }

    public static Optional<? extends Class<?>> getParameterAnnotation(CtParameter ctParameter, CtMethod ctMethod) {
        Optional<CtParameter<?>> interfaceParameter = TypeHelper.getInterfaceParameter(ctParameter, ctMethod);
        return interfaceParameter.map(p -> p.getAnnotations().stream().map(a -> a.getType().getTypeDeclaration().getActualClass()).filter(c -> c.isAssignableFrom(QueryParam.class) || c.isAssignableFrom(PathParam.class)).findFirst()).orElse(Optional.empty());
    }

    public static Optional<CtParameter<?>> getInterfaceParameter(CtParameter parameter, CtMethod ctMethod) {
        return TypeHelper.getInterfaceMethod(ctMethod).map(m -> m.getParameters().stream().filter(p -> parameter.getType().isSubtypeOf(p.getType())).filter(p -> p.getSimpleName().equals(parameter.getSimpleName())).findFirst()).orElse(Optional.empty());
    }
}

