/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.swagger.maven.spoon.processor.step;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ExternalDocs;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.text.WordUtils;
import org.camunda.bpm.swagger.docs.model.ParameterDescription;
import org.camunda.bpm.swagger.docs.model.RestOperation;
import org.camunda.bpm.swagger.docs.model.RestService;
import org.camunda.bpm.swagger.maven.spoon.SpoonProcessingMojo;
import org.camunda.bpm.swagger.maven.spoon.processor.ParameterRepository;
import org.camunda.bpm.swagger.maven.spoon.processor.StringHelper;
import org.camunda.bpm.swagger.maven.spoon.processor.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.CodeFactory;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;

public class MethodStep {
    private static final Logger log = LoggerFactory.getLogger(MethodStep.class);
    private final SpoonProcessingMojo.Context context;
    private final CodeFactory codeFactory;
    private final CoreFactory core;

    public MethodStep(SpoonProcessingMojo.Context context, Factory factory) {
        this.context = context;
        this.codeFactory = factory.Code();
        this.core = factory.Core();
    }

    public void process(CtMethod<?> ctMethod) {
        Class<? extends Annotation> jaxrsAnnotationClass;
        String className = ((CtType)ctMethod.getParent()).getQualifiedName();
        String methodName = ctMethod.getSimpleName();
        RestService restService = this.context.getServiceDocumentation().get(className);
        if (ctMethod.getAnnotation(Path.class) == null) {
            CtAnnotation pathAnnotation = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(Path.class));
            pathAnnotation.addValue("value", (Object)"/");
            ctMethod.addAnnotation(pathAnnotation);
        }
        if ((jaxrsAnnotationClass = TypeHelper.javaxRsAnnotation(ctMethod)) == null) {
            CtAnnotation jaxRsAnnotation = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(GET.class));
            ctMethod.addAnnotation(jaxRsAnnotation);
        }
        if (restService != null) {
            String description;
            RestOperation restOperation = (RestOperation)restService.getOperations().get(methodName);
            if (restOperation != null) {
                description = Optional.ofNullable(restOperation.getDescription()).orElse(WordUtils.capitalize((String)StringHelper.splitCamelCase(methodName)));
                if (!restOperation.getResponseCodes().keySet().isEmpty()) {
                    CtAnnotation responsesAnnotation = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(ApiResponses.class));
                    CtNewArray responses = this.core.createNewArray();
                    for (String code : restOperation.getResponseCodes().keySet()) {
                        CtAnnotation response = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(ApiResponse.class));
                        response.addValue("code", (Object)Integer.valueOf(code)).addValue("message", (Object)((ParameterDescription)restOperation.getResponseCodes().get(code)).getDescription());
                        responses.addElement((CtExpression)response);
                    }
                    responsesAnnotation.addValue("value", (Object)responses);
                    ctMethod.addAnnotation(responsesAnnotation);
                }
                if (restOperation.getExternalDocUrl() != null) {
                    CtAnnotation externalDocs = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(ExternalDocs.class));
                    externalDocs.addValue("value", (Object)"Reference Guide");
                    externalDocs.addValue("url", (Object)restOperation.getExternalDocUrl());
                    ctMethod.addAnnotation(externalDocs);
                }
                CtTypeReference apiImplicitParamsTypeRef = this.codeFactory.createCtTypeReference(ApiImplicitParams.class);
                for (CtParameter parameter : ctMethod.getParameters()) {
                    CtNewArray params;
                    if (!ParameterRepository.isPresent(parameter.getType().getQualifiedName())) {
                        ParameterDescription parameterDescription = null;
                        Optional<Class<?>> parameterAnnotation = TypeHelper.getParameterAnnotation(parameter, ctMethod);
                        if (parameterAnnotation.isPresent() && parameterAnnotation.get().isAssignableFrom(QueryParam.class)) {
                            parameterDescription = (ParameterDescription)restOperation.getQueryParameters().get(parameter.getSimpleName());
                        } else if (parameterAnnotation.isPresent() && parameterAnnotation.get().isAssignableFrom(PathParam.class)) {
                            parameterDescription = (ParameterDescription)restOperation.getPathParameters().get(parameter.getSimpleName());
                        }
                        String apiDocsParamName = Optional.ofNullable(parameterDescription).map(p -> p.getDescription()).orElse("Parameter " + parameter.getSimpleName());
                        CtAnnotation paramAnnotation = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(ApiParam.class));
                        paramAnnotation.addValue("value", (Object)apiDocsParamName);
                        parameter.addAnnotation(paramAnnotation);
                        continue;
                    }
                    if (!ParameterRepository.generateImplicitParams(parameter.getType().getQualifiedName())) continue;
                    CtAnnotation implicitParamsAnnotation = ctMethod.getAnnotation(apiImplicitParamsTypeRef);
                    if (implicitParamsAnnotation == null) {
                        implicitParamsAnnotation = this.codeFactory.createAnnotation(apiImplicitParamsTypeRef);
                        ctMethod.addAnnotation(implicitParamsAnnotation);
                        params = this.core.createNewArray();
                        implicitParamsAnnotation.addValue("value", (Object)params);
                    } else {
                        params = (CtNewArray)implicitParamsAnnotation.getValue("value");
                    }
                    for (String paramName : restOperation.getQueryParameters().keySet()) {
                        ParameterDescription parameterDescription = (ParameterDescription)restOperation.getQueryParameters().get(paramName);
                        CtAnnotation param = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(ApiImplicitParam.class));
                        param.addValue("name", (Object)paramName).addValue("value", (Object)(parameterDescription.getDescription() == null ? "Parameter" + paramName : parameterDescription.getDescription())).addValue("dataType", (Object)(parameterDescription.getType() == null ? "string" : parameterDescription.getType())).addValue("paramType", (Object)"query").addValue("required", (Object)(parameterDescription.getRequired() == null ? false : parameterDescription.getRequired()));
                        params.addElement((CtExpression)param);
                    }
                }
            } else {
                log.error("No method documentation found for {}#{}", (Object)className, (Object)methodName);
                description = WordUtils.capitalize((String)StringHelper.splitCamelCase(methodName));
            }
            log.debug("Annotating method {}#{}", (Object)className, (Object)ctMethod.getSimpleName());
            CtAnnotation apiOperation = this.codeFactory.createAnnotation(this.codeFactory.createCtTypeReference(ApiOperation.class));
            apiOperation.addValue("value", (Object)StringHelper.firstSentence(description));
            apiOperation.addValue("notes", (Object)description);
            ctMethod.addAnnotation(apiOperation);
        } else {
            log.error("No service documentation found for {}", (Object)className);
        }
    }
}

