/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.extension.xslt;

import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

/**
 * @author Stefan Hentschel.
 */
public class XsltCompiledScript extends CompiledScript {

  protected final ScriptEngine scriptEngine;
  protected final Templates templates;

  public XsltCompiledScript(ScriptEngine scriptEngine, Templates templates) {
    this.templates = templates;
    this.scriptEngine = scriptEngine;
  }

  public Object eval(ScriptContext context) throws ScriptException {
    Transformer transformer;

    try {
      transformer = templates.newTransformer();
      return ((XsltScriptEngine) scriptEngine).evaluate(transformer, context);
    } catch(TransformerException e) {
      throw new ScriptException(e);
    }
  }

  public ScriptEngine getEngine() {
    return scriptEngine;
  }
}
