/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.dmn;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.impl.AllowedAnswersImpl;
import org.camunda.bpm.model.dmn.impl.AllowedValueImpl;
import org.camunda.bpm.model.dmn.impl.AuthorityRequirementImpl;
import org.camunda.bpm.model.dmn.impl.BindingImpl;
import org.camunda.bpm.model.dmn.impl.BusinessContextElementImpl;
import org.camunda.bpm.model.dmn.impl.BusinessKnowledgeModelImpl;
import org.camunda.bpm.model.dmn.impl.ClauseImpl;
import org.camunda.bpm.model.dmn.impl.ColumnImpl;
import org.camunda.bpm.model.dmn.impl.ConclusionImpl;
import org.camunda.bpm.model.dmn.impl.ConditionImpl;
import org.camunda.bpm.model.dmn.impl.ContextEntryImpl;
import org.camunda.bpm.model.dmn.impl.ContextImpl;
import org.camunda.bpm.model.dmn.impl.DecisionImpl;
import org.camunda.bpm.model.dmn.impl.DecisionMadeReferenceImpl;
import org.camunda.bpm.model.dmn.impl.DecisionMakerReferenceImpl;
import org.camunda.bpm.model.dmn.impl.DecisionOwnedReferenceImpl;
import org.camunda.bpm.model.dmn.impl.DecisionOwnerReferenceImpl;
import org.camunda.bpm.model.dmn.impl.DecisionRuleImpl;
import org.camunda.bpm.model.dmn.impl.DecisionTableImpl;
import org.camunda.bpm.model.dmn.impl.DefinitionsImpl;
import org.camunda.bpm.model.dmn.impl.DescriptionImpl;
import org.camunda.bpm.model.dmn.impl.DmnElementImpl;
import org.camunda.bpm.model.dmn.impl.DmnElementReferenceImpl;
import org.camunda.bpm.model.dmn.impl.DmnParser;
import org.camunda.bpm.model.dmn.impl.DrgElementImpl;
import org.camunda.bpm.model.dmn.impl.DrgElementReferenceImpl;
import org.camunda.bpm.model.dmn.impl.ElementCollectionImpl;
import org.camunda.bpm.model.dmn.impl.ExpressionImpl;
import org.camunda.bpm.model.dmn.impl.FunctionDefinitionImpl;
import org.camunda.bpm.model.dmn.impl.ImpactedPerformanceIndicatorReferenceImpl;
import org.camunda.bpm.model.dmn.impl.ImpactingDecisionReferenceImpl;
import org.camunda.bpm.model.dmn.impl.ImportImpl;
import org.camunda.bpm.model.dmn.impl.InformationItemImpl;
import org.camunda.bpm.model.dmn.impl.InformationRequirementImpl;
import org.camunda.bpm.model.dmn.impl.InputDataImpl;
import org.camunda.bpm.model.dmn.impl.InputEntryImpl;
import org.camunda.bpm.model.dmn.impl.InputExpressionImpl;
import org.camunda.bpm.model.dmn.impl.InputVariableReferenceImpl;
import org.camunda.bpm.model.dmn.impl.InvocationImpl;
import org.camunda.bpm.model.dmn.impl.ItemComponentImpl;
import org.camunda.bpm.model.dmn.impl.ItemDefinitionImpl;
import org.camunda.bpm.model.dmn.impl.ItemDefinitionReferenceImpl;
import org.camunda.bpm.model.dmn.impl.KnowledgeRequirementImpl;
import org.camunda.bpm.model.dmn.impl.KnowledgeSourceImpl;
import org.camunda.bpm.model.dmn.impl.ListImpl;
import org.camunda.bpm.model.dmn.impl.LiteralExpressionImpl;
import org.camunda.bpm.model.dmn.impl.NamedDmnElementImpl;
import org.camunda.bpm.model.dmn.impl.OrganizationUnitImpl;
import org.camunda.bpm.model.dmn.impl.OutputDefinitionReferenceImpl;
import org.camunda.bpm.model.dmn.impl.OutputEntryImpl;
import org.camunda.bpm.model.dmn.impl.OwnerReferenceImpl;
import org.camunda.bpm.model.dmn.impl.ParameterReferenceImpl;
import org.camunda.bpm.model.dmn.impl.PerformanceIndicatorImpl;
import org.camunda.bpm.model.dmn.impl.QuestionImpl;
import org.camunda.bpm.model.dmn.impl.RelationImpl;
import org.camunda.bpm.model.dmn.impl.RequiredAuthorityReferenceImpl;
import org.camunda.bpm.model.dmn.impl.RequiredDecisionReferenceImpl;
import org.camunda.bpm.model.dmn.impl.RequiredInputReferenceImpl;
import org.camunda.bpm.model.dmn.impl.RequiredKnowledgeReferenceImpl;
import org.camunda.bpm.model.dmn.impl.RuleImpl;
import org.camunda.bpm.model.dmn.impl.SupportedObjectiveReferenceImpl;
import org.camunda.bpm.model.dmn.impl.TextImpl;
import org.camunda.bpm.model.dmn.impl.TypeDefinitionImpl;
import org.camunda.bpm.model.dmn.impl.TypeImpl;
import org.camunda.bpm.model.dmn.impl.TypeRefImpl;
import org.camunda.bpm.model.dmn.impl.UsingProcessReferenceImpl;
import org.camunda.bpm.model.dmn.impl.UsingTaskReferenceImpl;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.ModelBuilder;
import org.camunda.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.camunda.bpm.model.xml.impl.util.IoUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;

public class Dmn {
    public static Dmn INSTANCE = new Dmn();
    private DmnParser dmnParser = new DmnParser();
    private final ModelBuilder dmnModelBuilder = ModelBuilder.createInstance((String)"CMMN Model");
    private Model dmnModel;

    public static DmnModelInstance readModelFromFile(File file) {
        return INSTANCE.doReadModelFromFile(file);
    }

    public static DmnModelInstance readModelFromStream(InputStream stream) {
        return INSTANCE.doReadModelFromInputStream(stream);
    }

    public static void writeModelToFile(File file, DmnModelInstance modelInstance) {
        INSTANCE.doWriteModelToFile(file, modelInstance);
    }

    public static void writeModelToStream(OutputStream stream, DmnModelInstance modelInstance) {
        INSTANCE.doWriteModelToOutputStream(stream, modelInstance);
    }

    public static String convertToString(DmnModelInstance modelInstance) {
        return INSTANCE.doConvertToString(modelInstance);
    }

    public static void validateModel(DmnModelInstance modelInstance) {
        INSTANCE.doValidateModel(modelInstance);
    }

    public static DmnModelInstance createEmptyModel() {
        return INSTANCE.doCreateEmptyModel();
    }

    protected Dmn() {
        this.doRegisterTypes(this.dmnModelBuilder);
        this.dmnModel = this.dmnModelBuilder.build();
    }

    protected DmnModelInstance doReadModelFromFile(File file) {
        DmnModelInstance dmnModelInstance;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            dmnModelInstance = this.doReadModelFromInputStream(is);
        }
        catch (FileNotFoundException e) {
            try {
                throw new DmnModelException("Cannot read model from file " + file + ": file does not exist.");
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(is);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)is);
        return dmnModelInstance;
    }

    protected DmnModelInstance doReadModelFromInputStream(InputStream is) {
        return this.dmnParser.parseModelFromStream(is);
    }

    protected void doWriteModelToFile(File file, DmnModelInstance modelInstance) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.doWriteModelToOutputStream(os, modelInstance);
        }
        catch (FileNotFoundException e) {
            try {
                throw new DmnModelException("Cannot write model to file " + file + ": file does not exist.");
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(os);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)os);
    }

    protected void doWriteModelToOutputStream(OutputStream os, DmnModelInstance modelInstance) {
        this.doValidateModel(modelInstance);
        IoUtil.writeDocumentToOutputStream((DomDocument)modelInstance.getDocument(), (OutputStream)os);
    }

    protected String doConvertToString(DmnModelInstance modelInstance) {
        this.doValidateModel(modelInstance);
        return IoUtil.convertXmlDocumentToString((DomDocument)modelInstance.getDocument());
    }

    protected void doValidateModel(DmnModelInstance modelInstance) {
        this.dmnParser.validateModel(modelInstance.getDocument());
    }

    protected DmnModelInstance doCreateEmptyModel() {
        return this.dmnParser.getEmptyModel();
    }

    protected void doRegisterTypes(ModelBuilder modelBuilder) {
        AllowedAnswersImpl.registerType(modelBuilder);
        AllowedValueImpl.registerType(modelBuilder);
        AuthorityRequirementImpl.registerType(modelBuilder);
        BindingImpl.registerType(modelBuilder);
        BusinessContextElementImpl.registerType(modelBuilder);
        BusinessKnowledgeModelImpl.registerType(modelBuilder);
        ClauseImpl.registerType(modelBuilder);
        ColumnImpl.registerType(modelBuilder);
        ConclusionImpl.registerType(modelBuilder);
        ConditionImpl.registerType(modelBuilder);
        ContextEntryImpl.registerType(modelBuilder);
        ContextImpl.registerType(modelBuilder);
        DecisionImpl.registerType(modelBuilder);
        DecisionMadeReferenceImpl.registerType(modelBuilder);
        DecisionMakerReferenceImpl.registerType(modelBuilder);
        DecisionOwnedReferenceImpl.registerType(modelBuilder);
        DecisionOwnerReferenceImpl.registerType(modelBuilder);
        DecisionRuleImpl.registerType(modelBuilder);
        DecisionTableImpl.registerType(modelBuilder);
        DefinitionsImpl.registerType(modelBuilder);
        DescriptionImpl.registerType(modelBuilder);
        DmnElementImpl.registerType(modelBuilder);
        DmnElementReferenceImpl.registerType(modelBuilder);
        DrgElementImpl.registerType(modelBuilder);
        DrgElementReferenceImpl.registerType(modelBuilder);
        ElementCollectionImpl.registerType(modelBuilder);
        ExpressionImpl.registerType(modelBuilder);
        FunctionDefinitionImpl.registerType(modelBuilder);
        ImpactedPerformanceIndicatorReferenceImpl.registerType(modelBuilder);
        ImpactingDecisionReferenceImpl.registerType(modelBuilder);
        ImportImpl.registerType(modelBuilder);
        InformationItemImpl.registerType(modelBuilder);
        InformationRequirementImpl.registerType(modelBuilder);
        InputDataImpl.registerType(modelBuilder);
        InputEntryImpl.registerType(modelBuilder);
        InputExpressionImpl.registerType(modelBuilder);
        InputVariableReferenceImpl.registerType(modelBuilder);
        InvocationImpl.registerType(modelBuilder);
        ItemComponentImpl.registerType(modelBuilder);
        ItemDefinitionImpl.registerType(modelBuilder);
        ItemDefinitionReferenceImpl.registerType(modelBuilder);
        KnowledgeRequirementImpl.registerType(modelBuilder);
        KnowledgeSourceImpl.registerType(modelBuilder);
        ListImpl.registerType(modelBuilder);
        LiteralExpressionImpl.registerType(modelBuilder);
        ModelElementInstanceImpl.registerType((ModelBuilder)modelBuilder);
        NamedDmnElementImpl.registerType(modelBuilder);
        OrganizationUnitImpl.registerType(modelBuilder);
        OutputDefinitionReferenceImpl.registerType(modelBuilder);
        OutputEntryImpl.registerType(modelBuilder);
        OwnerReferenceImpl.registerType(modelBuilder);
        ParameterReferenceImpl.registerType(modelBuilder);
        PerformanceIndicatorImpl.registerType(modelBuilder);
        QuestionImpl.registerType(modelBuilder);
        RelationImpl.registerType(modelBuilder);
        RequiredAuthorityReferenceImpl.registerType(modelBuilder);
        RequiredDecisionReferenceImpl.registerType(modelBuilder);
        RequiredInputReferenceImpl.registerType(modelBuilder);
        RequiredKnowledgeReferenceImpl.registerType(modelBuilder);
        RuleImpl.registerType(modelBuilder);
        SupportedObjectiveReferenceImpl.registerType(modelBuilder);
        TextImpl.registerType(modelBuilder);
        TypeDefinitionImpl.registerType(modelBuilder);
        TypeImpl.registerType(modelBuilder);
        TypeRefImpl.registerType(modelBuilder);
        UsingProcessReferenceImpl.registerType(modelBuilder);
        UsingTaskReferenceImpl.registerType(modelBuilder);
    }

    public Model getDmnModel() {
        return this.dmnModel;
    }

    public ModelBuilder getDmnModelBuilder() {
        return this.dmnModelBuilder;
    }

    public void setDmnModel(Model dmnModel) {
        this.dmnModel = dmnModel;
    }
}

