/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.camunda.bpm.model.dmn.instance;

import java.util.Arrays;
import java.util.Collection;

import org.camunda.bpm.model.dmn.DecisionTableOrientation;
import org.camunda.bpm.model.dmn.HitPolicy;

public class DecisionTableTest extends DmnModelElementInstanceTest {

  public TypeAssumption getTypeAssumption() {
    return new TypeAssumption(Expression.class, false);
  }

  public Collection<ChildElementAssumption> getChildElementAssumptions() {
    return Arrays.asList(
      new ChildElementAssumption(Input.class),
      new ChildElementAssumption(Output.class, 1),
      new ChildElementAssumption(Rule.class)
    );
  }

  public Collection<AttributeAssumption> getAttributesAssumptions() {
    return Arrays.asList(
      new AttributeAssumption("hitPolicy", false, false, HitPolicy.UNIQUE),
      new AttributeAssumption("aggregation"),
      new AttributeAssumption("preferredOrientation", false, false, DecisionTableOrientation.Rule_as_Row),
      new AttributeAssumption("outputLabel")
    );
  }

}
